<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheFile.php,v 1.7 2008/03/29 06:11:46 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륭å奯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheFile.php,v 1.7 2008/03/29 06:11:46 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_CacheFile extends SyL_Cache
{
    /**
     * åǥ쥯ȥ
     *
     * @access private
     * @var string
     */
    var $cache_dir = '/tmp/';
    /**
     * 󥯥롼ɥåѥե饰
     *
     * @access private
     * @var bool
     */
    var $include_cache = false;
    /**
     * åեγǧCRCղä뤫
     *
     * @access private
     * @var bool
     */
    var $crc = true;
    /**
     * åե򥷥ꥢ벽뤫
     *
     * @access private
     * @var bool
     */
    var $serial = true;
    /**
     * Υåե̾
     *
     * @access private
     * @var bool
     */
    var $lockname = '.locking';

    /**
     * åǥ쥯ȥ򥻥åȤ
     *
     * @access public
     * @param string åǥ쥯ȥ
     */
    function setCacheDir($cache_dir)
    {
        if (is_dir($cache_dir)) {
            if (!is_writable($cache_dir)) {
                trigger_error("[SyL error] Cache directory permission denied ({$cache_dir})", E_USER_ERROR);
            }
        } else {
            if (!mkdir($cache_dir)) {
                trigger_error("[SyL error] Cache directory can't create ({$cache_dir})", E_USER_ERROR);
            }
            chmod($cache_dir, 0777);
        }
        if (!preg_match('/(\\\\|\/)$/', $cache_dir)) {
            $cache_dir .= '/';
        }
        $this->cache_dir = $cache_dir;
    }

    /**
     * 󥯥롼ɥåѤ
     *
     * @access public
     */
    function useIncludeCache()
    {
        $this->include_cache = true;
        $this->setCrc(false);
        $this->setSerialize(false);
    }

    /**
     * åι֤򹹿
     *
     * @access public
     * @param int (UNIX Time)
     * @return bool true: OKfalse: 顼
     */
    function setModifyTime($mtime=0)
    {
        $filename = $this->getFileName();
        if (!file_exists($filename)) {
            return false;
        }
        return ($mtime) ? touch($filename, $mtime) : touch($filename);
    }

    /**
     * åեι֤
     *
     * @access public
     * @return int (UNIX Time)
     */
    function getModifyTime()
    {
        $filename = $this->getFileName();
        if (!file_exists($filename)) {
            return false;
        }
        return filemtime($filename);
    }

    /**
     * åɤ߹
     *
     * @access public
     * @param bool å֤ͭ򹹿
     * @return mixed åǡ
     */
    function read($modify_time_update=false)
    {
        $filename = $this->getFileName();
        if (file_exists($filename)) {
            // åեOK
            $mtime = filemtime($filename);

            // ֤κǾȽ
            if ($this->min_mtime > 0) {
                if ($mtime < $this->min_mtime) {
                    return false;
                }
            }
            // ֤κȽ
            if ($this->max_mtime > 0) {
                if ($mtime > $this->max_mtime) {
                    return false;
                }
            }

            // ֤ͭ
            $life_time = ($this->life_time > 0) ? $mtime + $this->life_time : null;

            if (($life_time === null) || ($life_time >= time())) {
                $hash = null;
                if ($this->include_cache) {
                    $data = include $filename;
                } else {
                    $size = filesize($filename);

                    $mqr = get_magic_quotes_runtime();
                    set_magic_quotes_runtime(0);

                    $fp = fopen($filename, 'rb');
                    if (!$fp) {
                        return false;
                    }
                    $i = 0;
                    while (!flock($fp, LOCK_SH)) {
                        if ($i < 5) {
                            // 5ȥ饤
                            usleep(500000); // 0.5s
                            $i++;
                        } else {
                            fclose($fp);
                            return false;
                        }
                    }
                    if ($this->crc) {
                        $hash = fread($fp, 32);
                        $data = ($size > 32) ? fread($fp, $size-32) : '';
                    } else {
                        $data = fread($fp, $size);
                    }
                    flock($fp, LOCK_UN);
                    fclose($fp);

                    set_magic_quotes_runtime($mqr);
                }

                if (($hash === null) || ($hash == $this->getCrc($data))) {
                    if ($modify_time_update) {
                        $this->setModifyTime();
                    }
                    return $this->serial ? unserialize($data) : $data;
                } else {
                    $this->delete();
                    return false;
                }
            } else {
                // åͭڤ
                $this->delete();
                return false;
            }
        } else {
            // åե̵
            return false;
        }
    }

    /**
     * å¸
     *
     * @access public
     * @param mixed åǡ
     * @return bool true: ¸false: ¸顼
     */
    function write($data)
    {
        if ($this->include_cache) {
            $data = trim($data);
            if (substr($data, 0, 2) != '<?') {
                $data = "<?php\n" . $data;
            }
            if (substr($data, -2) != '?>') {
                $data .= "\n?>\n";
            }
        }

        // åե̾
        $filename = $this->getFileName();
        // ǡΥꥢ벽
        if ($this->serial) {
            $data = serialize($data);
        }
        // ǡΥХȿ
        $size = strlen($data);

        $fp = fopen($filename, 'wb');
        if (!$fp) {
            return false;
        }

        $i = 0;
        while (!flock($fp, LOCK_EX)) {
            if ($i < 5) {
                // 5ȥ饤
                usleep(500000); // 0.5s
                $i++;
            } else {
                fclose($fp);
                return false;
            }
        }

        if ($this->crc) {
            fwrite($fp, $this->getCrc($data), 32);
        }

        fwrite($fp, $data, $size);
        fclose($fp);

        @chmod($filename, 0777);
        return true;
    }

    /**
     * å
     * 
     * @access public
     * @return bool true: false: 顼
     */
    function delete()
    {
        $filename = $this->getFileName();
        return file_exists($filename) ? @unlink($filename) : false;
    }

    /**
     * ǥ쥯ȥΥåե
     *
     * @access private
     */
    function clean()
    {
        if (!is_dir($this->cache_dir)) {
            trigger_error("[SyL error] Cache directory property not set ({$this->cache_dir})", E_USER_ERROR);
        }
        if ($this->life_time == 0) {
            return;
        }

        $lockfile = "{$this->cache_dir}/__{$this->prefix}{$this->lockname}";
        if (is_file($lockfile)) {
            // åե뤬ϡԤʤ
            return;
        }

        $fp = @fopen($lockfile, 'wb');
        if (!$fp) return;
        if (!@flock($fp, LOCK_EX)) {
            fclose($fp);
            return;
        }

        $now = time();

        $dh = opendir($this->cache_dir);
        while (($filename = readdir($dh)) !== false) {
            $filename = basename($filename);
            if (is_file("{$this->cache_dir}/{$filename}")) {
                if ($this->prefix) {
                    if (!preg_match('/^(' . preg_quote($this->prefix, '/') . ')/', $filename)) {
                        continue;
                    }
                }
                $filename = "{$this->cache_dir}/{$filename}";
                $mtime = filemtime($filename);
                // ֤κǾȽ
                if ($this->min_mtime && ($mtime < $this->min_mtime)) {
                    @unlink($filename);
                // ֤κȽ
                } else if ($this->max_mtime && ($mtime > $this->max_mtime)) {
                    @unlink($filename);
                // ¸֤Ƚ
                } else if ($now > ($mtime + $this->life_time)) {
                    @unlink($filename);
                }
            }
        }
        closedir($dh);

        fclose($fp);
        @unlink($lockfile);
    }

    /**
     * åƺ
     *
     * @access public
     */
    function cleanAll()
    {
        if (!is_dir($this->cache_dir)) {
            trigger_error("[SyL error] Cache directory property not set ({$this->cache_dir})", E_USER_ERROR);
        }

        $lockfile = "{$this->cache_dir}/__{$this->prefix}{$this->lockname}";
        if (is_file($lockfile)) {
            // åե뤬ϡԤʤ
            return;
        }

        $fp = @fopen($lockfile, 'w');
        if (!$fp) return;
        if (!@flock($fp, LOCK_EX)) {
            fclose($fp);
            return;
        }

        $dh = opendir($this->cache_dir);
        while (($filename = readdir($dh)) !== false) {
            if (is_file($this->cache_dir . $filename)) {
                @unlink($this->cache_dir . $filename);
            }
        }
        closedir($dh);

        fclose($fp);
        @unlink($lockfile);
    }

    /**
     * åե̾
     * 
     * @access public
     * @param string åեȽꥭ
     * @return string åե̾
     */
    function getFileName()
    {
        return $this->cache_dir . $this->getKey();
    }

    /**
     * CRCɲȽե饰򥻥å
     * 
     * @access public
     * @param bool CRCɲȽե饰
     */
    function setCrc($flag)
    {
        $this->crc = (bool)$flag;
    }

    /**
     * CRCɲäǡ
     * 
     * @access public
     * @param string ǡ
     * @return string ϥå
     */
    function getCrc($data)
    {
        return sprintf('%+032d', crc32($data));
    }

    /**
     * ꥢ벽Ƚե饰򥻥å
     * 
     * @access public
     * @param bool ꥢ벽Ƚե饰
     */
    function setSerialize($flag)
    {
        $this->serial = (bool)$flag;
    }
}

?>
