<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilderColumn.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQLǡ饹
 */
require_once 'SyL_DBSqlBuilderColumnData.php';

/**
 * SQL९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilderColumn.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSqlBuilderColumn
{
    /**
     * ơ֥륪֥
     *
     * @access private
     * @var object
     */
    var $table = null;
    /**
     * ̾
     *
     * @access private
     * @var string
     */
    var $name  = '';
    /**
     * ̾
     *
     * @access private
     * @var string
     */
    var $alias = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ơ֥륪֥
     * @param string ̾
     * @param string ̾
     */
    function SyL_DBSqlBuilderColumn(&$table, $name, $alias='')
    {
        $this->table =& $table;
        $this->name  = $name;
        $this->alias = $alias;
    }

    /**
     * ̾
     *
     * @access public
     * @return string ơ֥̾
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getNameAlias()
    {
        return $this->alias;
    }

    /**
     * SELECTѥ̾
     *
     * @access public
     * @return string ̾
     */
    function getNameSelect()
    {
        $table = $this->table->getNameAlias();
        if (!$table) {
            $table = $this->table->getName();
        }

        $alias = $this->getNameAlias();
        if ($alias) {
            return $table . '.' . $this->getName() . ' AS ' . $alias;
        } else {
            return $table . '.' . $this->getName();
        }
    }

    /**
     * WHEREѥ̾
     *
     * @access public
     * @return string ̾
     */
    function getNameWhere()
    {
        $table = $this->table->getNameAlias();
        if (!$table) {
            $table = $this->table->getName();
        }
        return $table . '.' . $this->getName();
    }

    /**
     * GROUP BYѥ̾
     *
     * @access public
     * @return string ̾
     */
    function getNameGroupBy()
    {
        $alias = $this->getNameAlias();
        if ($alias) {
            return $alias;
        } else {
            $table = $this->table->getName();
            return $table . '.' . $this->getName();
        }
    }

    /**
     * ORDER BYѥ̾
     *
     * @access public
     * @return string ̾
     */
    function getNameOrderBy()
    {
        return $this->getNameGroupBy();
    }

    /**
     * ǡ֥Ȥ
     *
     * @access public
     * @param string ǡ
     * @param string ڥ졼
     * @return object ǡ֥
     */
    function getColumnData($data, $operator='=')
    {
        return new SyL_DBSqlBuilderColumnData($this, $data, $operator);
    }
}

?>
