<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClient.php,v 1.6 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * åȥ饹
 */
require_once dirname(__FILE__) . '/../SyL_Socket.php';
/**
 * HTTP饤ȥꥯȥ饹
 */
require_once 'SyL_HttpClientRequest.php';
/**
 * HTTP饤ȥ쥹ݥ󥹥饹
 */
require_once 'SyL_HttpClientResponse.php';

/**
 * HTTP饤ȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_HttpClient.php,v 1.6 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_HttpClient
{
    /**
     * ꥯоݥۥ̾
     * 
     * @access private
     * @var string
     */
    var $host = '';
    /**
     * ꥯоݥݡֹ
     * 
     * @access private
     * @var int
     */
    var $port = 80;
    /**
     * SSLȽ
     * 
     * @access private
     * @var bool
     */
    var $ssl = false;
    /**
     * ॢ [s]
     *
     * var int
     */
    var $timeout = 5;
    /**
     * 顼å
     * 
     * @access private
     * @var string
     */
    var $error_message = '';
    /**
     * ꥯȥȥ졼᥽å
     * 
     * @access private
     * @var mixed
     */
    var $callback_trace = null;

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     * @param string ꥯоݥۥ̾
     * @param int ꥯоݥݡֹ
     * @param bool SSLȽ
     */
    function SyL_HttpClient($host, $port=80, $ssl=false)
    {
      $this->host = $host;
      $this->port = $port;
      $this->ssl  = $ssl;
      // ǥեȥХå᥽å
      $this->callback_trace = array(&$this, 'trace');
    }

    /**
     * ѥ᡼֥Ȥ
     * 
     * @access protected
     * @param string ꥯURL
     * @param string ꥯȥ᥽å
     */
    function &createRequest($url='/', $method='GET')
    {
        $request =& new SyL_HttpClientRequest($url, $method);
        return $request;
    }

    /**
     * 顼Ƚ
     * 
     * @access public
     * @return bool true: 顼ꡣfalse: 顼̵
     */
    function isError()
    {
        return ($this->error_message ? true : false);
    }

    /**
     * 顼å
     * 
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * ꥯȤơ쥹ݥ󥹥֥Ȥ
     * 
     * @access public
     * @param object ꥯȥѥ᡼֥
     * @param string 饤ȥ󥳡
     */
    function &sendRequest(&$request, $client_encode='')
    {
        // ۥȥإåѥå
        if (!$request->isHeader('host') && !preg_match('/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/', $this->host)) {
            $request->setHeader('host', $this->host);
        }

        $host = ($this->ssl) ? 'ssl://' . $this->host : $this->host;
        $socket = new SyL_Socket($host, $this->port);
        $socket->setCommandCallBackFunc($this->callback_trace);

        if (!$socket->open($this->timeout)) {
            $this->error_message = $socket->getLastError();
            return false;
        }

        if (!$socket->send($request->getSource())) {
            $this->error_message = $socket->getLastError();
            return false;
        }

        $data = $socket->receiveAll(true);
        $socket->close();

        return $this->createResponse($data, $client_encode);
    }

    /**
     * ̥֥Ȥ
     * 
     * @access protected
     * @param string 쥹ݥ󥹥ǡ
     * @param string 饤ȥ󥳡
     */
    function &createResponse(&$data, $client_encode='')
    {
        $response =& new SyL_HttpClientResponse($data, $client_encode);
        return $response;
    }

    /**
     * 쥹ݥ󥹥Хå᥽å
     * 
     * @access public
     * @param string send or recieve
     * @param string å
     */
    function trace($type, $message)
    {
    }
}

?>
