<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelHotelDetailSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷȥ٥߾APIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷȥ٥߾API  
 *   http://webservice.rakuten.co.jp/api/hoteldetailsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelHotelDetailSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceTravelHotelDetailSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * ߾
     *
     * @access private
     * @var array
     */
    var $hotel = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        switch ($current_path) {
        // =============================
        // 
        // =============================
        // ֹ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelNo': $this->hotel['hotelNo'] = $text; break;
        // ̾
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelName': $this->hotel['hotelName'] = $text; break;
        // ͹ֹ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/postalCode': $this->hotel['postalCode'] = $text; break;
        // ꣱
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/address1': $this->hotel['address1'] = $text; break;
        // ꣲ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/address2': $this->hotel['address2'] = $text; break;
        // ֹ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/telephoneNo': $this->hotel['telephoneNo'] = $text; break;
        // եåֹ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/faxNo': $this->hotel['faxNo'] = $text; break;
        // å
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/checkinTime': $this->hotel['checkinTime'] = $text; break;
        // ǽå
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/lastCheckinTime': $this->hotel['lastCheckinTime'] = $text; break;
        // åȻ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/checkoutTime': $this->hotel['checkoutTime'] = $text; break;
        // 
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/latitude': $this->hotel['latitude'] = $text; break;
        // 
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/longitude': $this->hotel['longitude'] = $text; break;
        // ߤؤΥ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/access': $this->hotel['access'] = $text; break;
        // ־
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/parkingInformation': $this->hotel['parkingInformation'] = $text; break;
        // ÿ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelSpecial': $this->hotel['hotelSpecial'] = $text; break;
        // 
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/roomFixture': $this->hotel['roomFixture'] = $text; break;
        // 
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelFixture': $this->hotel['hotelFixture'] = $text; break;
        // ŵ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/privilege': $this->hotel['privilege'] = $text; break;
        // ݥȲûˤĤ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutPointAdd': $this->hotel['aboutPointAdd'] = $text; break;
        // ޥ졼ûˤĤ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutMileageAdd': $this->hotel['aboutMileageAdd'] = $text; break;
        // ˤĤ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutMealPlace': $this->hotel['aboutMealPlace'] = $text; break;
        // ϤˤĤ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutBath': $this->hotel['aboutBath'] = $text; break;
        // Ѳǽʥ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/availableCreditCard': $this->hotel['availableCreditCard'] = $text; break;
        // ѤˤĤ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutCreditCardNote': $this->hotel['aboutCreditCardNote'] = $text; break;
        // դΥ쥸㡼ˤĤ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutLeisure': $this->hotel['aboutLeisure'] = $text; break;
        // ջࡦ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/note': $this->hotel['note'] = $text; break;
        // 󥻥ݥꥷ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/cancelPolicy': $this->hotel['cancelPolicy'] = $text; break;
        // ߤθ٥ˤĤ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/linguisticLevel': $this->hotel['linguisticLevel'] = $text; break;
        // Ⱦ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/handicappedFixture': $this->hotel['handicappedFixture'] = $text; break;
        // ¾
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/otherInformation': $this->hotel['otherInformation'] = $text; break;
        // ߲URL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelImageUrl': $this->hotel['hotelImageUrl'] = $text; break;
        // URL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/roomImageUrl': $this->hotel['roomImageUrl'] = $text; break;
        // Ͽ޲URL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelMapImageUrl': $this->hotel['hotelMapImageUrl'] = $text; break;
        // ߾ڡURL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelInformationUrl': $this->hotel['hotelInformationUrl'] = $text; break;
        // ߾ڡեꥨURL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelAffiliateUrl': $this->hotel['hotelAffiliateUrl'] = $text; break;
        // ͽ󥻥󥿡ֹ
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/reserveTelephoneNo': $this->hotel['reserveTelephoneNo'] = $text; break;

        // 嵭ʳ
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * ߾
     *
     * @access public
     * @param string ̾
     * @return mixed ߾
     */
    function getHotel($name=null)
    {
        if ($name !== null) {
            return isset($this->hotel[$name]) ? $this->hotel[$name] : null;
        } else {
            return $this->hotel;
        }
    }
}

?>
