<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchRequest.php,v 1.2 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - Ͽ޾ - 륵API
 */
require_once 'SyL_WebServiceMapLocalSearchResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - Ͽ޾ - 륵API
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * Ͽ޾ - 륵API
 *   http://developer.yahoo.co.jp/map/localsearch/V1/localsearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchRequest.php,v 1.2 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMapLocalSearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'map.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/LocalSearchService/V1/LocalSearch';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMapLocalSearchResponse';

    /**
     * ɤ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setP($p)
    {
        parent::set('p', $p);
    }

    /**
     * ٤򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setLat($lat)
    {
        parent::set('lat', $lat);
    }

    /**
     * ٤򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setLon($lon)
    {
        parent::set('lon', $lon);
    }

    /**
     * Υñkmˤ򥻥åȤ
     *
     * @access public
     * @param float Υñkm
     */
    function setDist($dist)
    {
        if (is_numeric($dist)) {
            parent::set('dist', $dist);
        } else {
            trigger_error("[SyL error] Invalid `dist' property ({$dist}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * оݥƥ򥻥åȤ
     *
     * @access public
     * @param string оݥƥ
     */
    function setCategory($category)
    {
        switch ($category) {
        case 'address':  // оݤ˸ 
        case 'zipcode':  // ͹ֹоݤ˸ 
        case 'landmark': // ߡꡢع±͹ضɤʤɡˤоݤ˸ 
        case 'station':  // ؤоݤ˸
        case 'courpon':  // Yahoo!ݥоݤ˸
            parent::set('category', $category);
            break;
        default:
            trigger_error("[SyL error] Invalid `category' property ({$category}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ɽϰ֤򥻥åȤ
     *
     * @access public
     * @param int ɽϰ
     */
    function setB($b)
    {
        if (preg_match('/^\d+$/', $b)) {
            $results = isset($this->parameters['n']) ? $this->parameters['n'] : 10;
            if (($b + $results - 1) <= 100) {
                parent::set('b', $b);
            } else {
                trigger_error("[SyL error] Invalid `b' property ({$b}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `b' property ({$b}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ɽ򥻥åȤ
     *
     * @access public
     * @param int ɽ
     */
    function setN($n)
    {
        if (preg_match('/^\d+$/', $n) && (($n >= 0) && ($n <= 100))) {
            parent::set('n', $n);
        } else {
            trigger_error("[SyL error] Invalid `n' property ({$n}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ϥפ򥻥åȤ
     *
     * @access public
     * @param string ϥ
     */
    function setO($o)
    {
        switch ($o) {
        case 'xml':
        //case 'json': // ܥ饤֥Ǥ̤б
            parent::set('o', $o);
            break;
        default:
            trigger_error("[SyL error] Invalid `o' property ({$o}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ٷ٤¬ϷϤ򥻥åȤ
     *
     * @access public
     * @param string ٷ٤¬Ϸ
     */
    function setDatum($datum)
    {
        switch ($datum) {
        case 'tky':
        case 'wgs':
            parent::set('datum', $datum);
            break;
        default:
            trigger_error("[SyL error] Invalid `datum' property ({$datum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ٥ιʤߤ򥻥åȤ
     *
     * @access public
     * @param int ٥ιʤ
     */
    function setAl($al)
    {
        switch ((string)$al) {
        case '1': // ԶĮ¼٥
        case '2': // Į٥
        case '3': // ܡ٥
            parent::set('al', $al);
            break;
        default:
            trigger_error("[SyL error] Invalid `al' property ({$al}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
