/**
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!SyL) var SyL = {};
if (!SyL.UI) SyL.UI = {};
if (!SyL.UI.Table) SyL.UI.Table = {};

/**
 * 饹
 */
SyL.UI.Table.Calender = function(id, tableId)
{
  this.tableClass        = "syl-tablecalender";
  this.tableClassHeader  = "syl-tablecalender-header";
  this.tableClassWeek    = "syl-tablecalender-week";
  this.tableClassWeekSud = "syl-tablecalender-week-sud";
  this.tableClassWeekWed = "syl-tablecalender-week-wed";
  this.tableClassWeekSad = "syl-tablecalender-week-sad";
  this.tableClassDay     = "syl-tablecalender-day";
  this.tableClassDaySud  = "syl-tablecalender-day-sud";
  this.tableClassDayWed  = "syl-tablecalender-day-wed";
  this.tableClassDaySad  = "syl-tablecalender-day-sad";
  this.textPrevLink = "";
  this.textNextLink = "";
  this.weeks = ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
  this.initialize(id, tableId);
}

SyL.UI.Table.Calender.prototype = {
  initialize: function(id, tableId)
  {
    var years  = [];

    var currentDate   = null;
    var callbackMonth = null;
    var callbackDay   = null;
    var nationalHoliday = false;
    var displayHeader = true;

    var links = {};

    var className = (/*@cc_on!@*/false) ? "className" : "class";

    var self = this;

    this.setNationalHoliday = function(holiday)
    {
      nationalHoliday = !!holiday;
    };
    this.setDisplayHeader = function(header)
    {
      displayHeader = !!header;
    };
    this.setDayLink = function(i, link)
    {
      if (!i || (i < 1) || (i > 31)) {
        throw "[SyL.UI.Calender.setDayLink] Invalid parameter (" + i + ")";
      }
      if (!link) link = null;
      links[i+""] = link;
    };
    this.clearDayLink = function()
    {
      links = {};
    };
    this.addYear = function(year)
    {
      years.push(year);
    };
    this.clearYear = function()
    {
      years = [];
    };
    this.setCurrentDate = function(currentDatet)
    {
      if ((typeof(currentDatet) != "string") ||
          !currentDatet.match(/^\d{4}([01][0-9])([0-3][0-9])$/)) {
         throw "[SyL.UI.Calender.setCurrentDate] Invalid parameter (" + currentDatet + ")";
      }
      var y = currentDatet.substr(0, 4) - 0; 
      var m = currentDatet.substr(4, 2) - 1;
      var d = currentDatet.substr(6, 2) - 0; 
      var dt = new Date(y, m, d); 
      if (!dt ||
          (dt.getFullYear() != y) ||
          (dt.getMonth() != m) ||
          (dt.getDate() != d)) { 
        throw "[SyL.UI.Calender.setCurrentDate] Invalid date (" + currentDatet + ")";
      }
      currentDate = currentDatet;
    };
    this.setMonthLinkCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        callbackMonth = callback;
      } else {
        throw "[SyL.UI.Calender.setMonthLinkCallback] Invalid parameter (" + callback + ")";
      }
    };
    this.setDayLinkCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        callbackDay = callback;
      } else {
        throw "[SyL.UI.Calender.setDayLinkCallback] Invalid parameter (" + callback + ")";
      }
    };
    this.create = function(ym)
    {
      if (!ym || !ym.match(/^(\d{4})([01][0-9])$/g)) {
        throw "[SyL.UI.Calender.create] Invalid parameter (" + ym + ")";
      }

      var y = parseInt(RegExp.$1, 10);
      var m = parseInt(RegExp.$2, 10);

      if ((m < 1) || (m > 12)) {
        throw "[SyL.UI.Calender.create] Invalid parameter (" + ym + ")";
      }

      var prev = '';
      var next = '';
      switch (m) {
      case 1:
        prev = (y-1) + "12";
        next = y + "02";
        break;
      case 12:
        prev = y + "11";
        next = (y+1) + "01";
        break;
      default:
        prev = y + ((m-1<10) ? "0"+(m-1) : String(m-1));
        next = y + ((m+1<10) ? "0"+(m+1) : String(m+1));
        break;
      }

      var date = new Date(y, m-1, 1);
      // 1ܤ
      var weekdate = date.getDay();
      // κǽ
      var lastday = (new Date(y, m, 0)).getDate();

      var div = document.getElementById(id);
      div.innerHTML = '';

      var form  = document.createElement("form");
      form.style.padding = "0px";
      form.style.margin  = "0px";

      var table = document.createElement("table");
      if (tableId) {
        table.id = tableId;
      }
      table.setAttribute(className, this.tableClass);

      var tbody = document.createElement("tbody");
      div.appendChild(form);
      form.appendChild(table);
      table.appendChild(tbody);

      if (displayHeader) {
        var tr = document.createElement("tr");
        var td = document.createElement("td");
        td.setAttribute(className, this.tableClassHeader);
        td.colSpan = "5";
        td.style.textAlign = "left";

        if (years.length > 0) {
          td.appendChild(createSelectYear(years, y));
          td.appendChild(document.createTextNode("/"));
          td.appendChild(createSelectMonth(m));
          td.appendChild(document.createTextNode(" "));
          td.appendChild(createSelectButton());
        } else {
          td.innerHTML = y + "&nbsp;/&nbsp;" + m;
        }
        tr.appendChild(td);

        var td = document.createElement("td");
        td.setAttribute(className, this.tableClassHeader);
        td.colSpan = "2";
        td.style.textAlign = "right";

        var aprev = document.createElement("a");
        aprev.href    = "javascript:void(0);";
        aprev.onclick = function() {
          if (typeof(callbackMonth) == "function") {
            callbackMonth(prev);
          } else {
            self.create(prev);
          }
        };
        aprev.innerHTML = this.textPrevLink;

        var anext = document.createElement("a");
        anext.href = "javascript:void(0);";
        anext.onclick = function() {
          if (typeof(callbackMonth) == "function") {
            callbackMonth(next);
          } else {
            self.create(next);
          }
        };
        anext.innerHTML = this.textNextLink;

        td.appendChild(aprev);
        td.appendChild(document.createTextNode(" | "));
        td.appendChild(anext);
        tr.appendChild(td);
        tbody.appendChild(tr);
      }

      // ̱ν
      var nationalHolidays = [];
      if (nationalHoliday) {
          nationalHolidays = getNationalHoliday(y, m);
      }

      var tr = document.createElement("tr");
      tr.setAttribute(className, this.tableClassWeek);
      for(var i=0; i<7; i++) {
        var td = createTdDay(ym, null, i, true, nationalHolidays);
        td.innerHTML = this.weeks[i];
        tr.appendChild(td);
      }
      tbody.appendChild(tr);

      var day = 1;
      var first = true;
      while (true) {
        var tr = document.createElement("tr");
        tr.setAttribute(className, this.tableClassDay);
        var n = 0;
        if (first) {
          // blank day
          for (var i=0; i<weekdate; i++) {
            var td = createTdDay(ym, null, i, false, nationalHolidays);
            td.innerHTML = "&nbsp;";
            tr.appendChild(td);
          }
          n = weekdate;
          first = false;
        }

        for (var i=n; i<7; i++) {
          if (day > lastday) {
            for(var k=i; k<7; k++) {
              var td = createTdDay(ym, null, k, false, nationalHolidays);
              td.innerHTML = "&nbsp;";
              tr.appendChild(td);
            }
            break;
          }

          var td = createTdDay(ym, day, i, false, nationalHolidays);
          var a  = document.createElement("a");

          if (links) {
            a.style.textDecoration = "underline";
            if (links[day]) {
              if (typeof(callbackDay) == "function") {
                a.href = "javascript:void(0);";
                a.onclick = function() {
                  var d = parseInt(this.innerHTML, 10);
                  callbackDay(y, m, d, links[d]);
                };
              } else {
                a.href = links[day];
              }
            } else {
              a.style.textDecoration = "none";
            }
          } else {
            if (typeof(callbackDay) == "function") {
              a.style.textDecoration = "underline";
              a.href = "javascript:void(0);";
              a.onclick = function(){
                callbackDay(y, m, parseInt(this.innerHTML,10));
              };
            } else {
              a.style.textDecoration = "none";
            }
          }
          a.innerHTML = day;
          td.appendChild(a);
          tr.appendChild(td);
          day++;
        }
        tbody.appendChild(tr);
  
        if (day > lastday) {
          break;
        }
      }

      function createTdDay(ym, day, week, header, nationalHolidays)
      {
        var cday = 0;
        if (ym && day && currentDate) {
          if (currentDate.substr(0, 6) == ym) {
            cday = parseInt(currentDate.substr(6, 2), 10);
          }
        }

        // ̱ν Ū˵ˡˤѴ
        if (nationalHolidays[day]) {
          week = 0;
        }
 
        var td = document.createElement("td");
        td.width = "14.2%";
        if (day == cday) {
          td.style.fontWeight = "bold";
        }

        switch (week) {
        case 0:  td.setAttribute(className, (header ? self.tableClassWeekSud : self.tableClassDaySud)); break;
        case 6:  td.setAttribute(className, (header ? self.tableClassWeekSad : self.tableClassDaySad)); break;
        default: td.setAttribute(className, (header ? self.tableClassWeekWed : self.tableClassDayWed)); break;
        }

        return td;
      };

      function createSelectYear(y, year)
      {
        var select = document.createElement("select");
        for (var i in y) {
          var option = document.createElement("option");
          if (y[i] == year) {
            option.selected = true;
          }
          option.value = y[i];
          option.appendChild(document.createTextNode(y[i]));
          select.appendChild(option);
        }
        return select;
      };

      function createSelectMonth(month)
      {
        var select = document.createElement("select");
        for (var i=1; i<=12; i++) {
          var option = document.createElement("option");
          if (i == month) {
            option.selected = true;
          }
          i = (i < 10) ? "0"+i : String(i);
          option.value = i;
          option.appendChild(document.createTextNode(i));
          select.appendChild(option);
        }
        return select;
      };

      function createSelectButton()
      {
        var input = document.createElement("input");
        input.type = "button";
        input.value = "OK";
        input.onclick = function() {
          var y = this.form.elements[0].options[this.form.elements[0].selectedIndex].value;
          var m = this.form.elements[1].options[this.form.elements[1].selectedIndex].value;
          self.create(y + m);
        }
        return input;
      };

      function getNationalHoliday(year, month)
      {
        var nationalHolidays = [];

        var self = this;
        switch (month) {
        // 1
        case 1:
          // 
          if (isSunday(year, month, 1)) {
            nationalHolidays[2] = true;
          } else {
            nationalHolidays[1] = true;
          }
          // ͤ
          var day = getFirstMonday(year, month) + 7;
          nationalHolidays[day] = true;
          break;
        // 2
        case 2:
          // ǰ
          if (isSunday(year, month, 11)) {
            nationalHolidays[12] = true;
          } else {
            nationalHolidays[11] = true;
          }
          break;
        // 3
        case 3:
          // ʬ
          if ((year > 1979) && (year < 2100)) {
            var day = parseInt(20.8431 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
            if (isSunday(year, month, day)) {
              nationalHolidays[day+1] = true;
            } else {
              nationalHolidays[day] = true;
            }
          }
          break;
        // 4
        case 4:
          // ߤɤ
          if (isSunday(year, month, 29)) {
            nationalHolidays[30] = true;
          } else {
            nationalHolidays[29] = true;
          }
          break;
        // 5
        case 5:
          // ˡǰ
          // ̱ε
          // ɤ
          if (isSunday(year, month, 3)) {
            nationalHolidays[4] = true;
            nationalHolidays[5] = true;
            nationalHolidays[6] = true;
          } else if (isSunday(year, month, 4)) {
            nationalHolidays[3] = true;
            nationalHolidays[5] = true;
            nationalHolidays[6] = true;
          } else if (isSunday(year, month, 5)) {
            nationalHolidays[3] = true;
            nationalHolidays[4] = true;
            nationalHolidays[6] = true;
          } else {
            nationalHolidays[3] = true;
            nationalHolidays[4] = true;
            nationalHolidays[5] = true;
          }
          break;
        // 6
        case 6: break;
        // 7
        case 7:
          // 
          var day = getFirstMonday(year, month) + 14;
          if (isSunday(year, month, day)) {
            nationalHolidays[day+1] = true;
          } else {
            nationalHolidays[day] = true;
          }
          break;
        // 8
        case 8: break;
        // 9
        case 9:
          // ʬ
          if ((year > 1979) && (year < 2100)) {
            var day = parseInt(23.2488 + 0.242194 * (year - 1980) - parseInt((year - 1980) / 4));
            if (isSunday(year, month, day)) {
              nationalHolidays[day+1] = true;
            } else {
              nationalHolidays[day] = true;
            }
          }
          // Ϸ
          var day = getFirstMonday(year, month) + 14;
          if (isSunday(year, month, day)) {
            nationalHolidays[day+1] = true;
          } else {
            nationalHolidays[day] = true;
          }
          break;
        // 10
        case 10:
          // ΰ
          var day = getFirstMonday(year, month) + 7;
          if (isSunday(year, month, day)) {
            nationalHolidays[day+1] = true;
          } else {
            nationalHolidays[day] = true;
          }
          break;
        // 11
        case 11:
          // ʸ
          if (isSunday(year, month, 3)) {
            nationalHolidays[4] = true;
          } else {
            nationalHolidays[3] = true;
          }
          // ϫդ
          if (isSunday(year, month, 23)) {
            nationalHolidays[24] = true;
          } else {
            nationalHolidays[23] = true;
          }
          break;
        // 12
        case 12:
          // ŷ
          if (isSunday(year, month, 23)) {
            nationalHolidays[24] = true;
          } else {
            nationalHolidays[23] = true;
          }
          break;
        }

        return nationalHolidays;
      };

      function getFirstMonday(year, month)
      {
        for(var day=1; day<=7; day++) {
            if ((new Date(year, month-1, day)).getDay() == 1) {
                return day;
            }
        }
      };

      function isSunday(year, month, day)
      {
        return ((new Date(year, month-1, day)).getDay() == 0);
      };
    };
  }
}


/**
 * ɽ饹
 */
SyL.UI.Table.List = function(id)
{
  this.headerClass ="syl-tablelist-header";
  this.pageActiveClass ="syl-tablelist-page-active";

  this.tableClass = "syl-tablelist";
  this.trClass    = "syl-tablelist-tr";
  this.trActiveClass = null;
  this.tr1Class    = "syl-tablelist-tr1";
  this.tr2Class    = "syl-tablelist-tr2";
  this.thAscClass  = "syl-tablelist-th-asc";
  this.thDescClass = "syl-tablelist-th-desc";

  this.searchCallback         = null;
  this.searchComplateCallback = null;

  this.initialize(id);
};

SyL.UI.Table.List.prototype = {
  initialize: function(id)
  {
    var headers = [];
    var columns = [];

    var sortCurrentKey = '';
    var sortCurrentOrder = '';

    var url   = null;
    var page  = 1;
    var row   = 20;
    var count = 0;
    var startPage = 0;
    var endPage = 0;

    var parameters = {};

    var className = (/*@cc_on!@*/false) ? "className" : "class";
    var floatName = (/*@cc_on!@*/false) ? "styleFloat" : "cssFloat";

    var self = this;

    this.setHeaders = function(headerst)
    {
      if (headerst instanceof Array) {
        for (var i=0; i<headerst.length; i++) {
          headers[headerst[i]] = {"name": headerst[i]};
        }
      } else if (typeof(headerst) == "object") {
        headers = headerst;
      } else {
        throw "[SyL.UI.Table.List.setHeaders] Invalid parameter format (" + typeof(headerst) + ")";
      }
    };

    this.addColumns = function(columnst)
    {
      columns.push(columnst);
    };

    this.setAjax = function(urlt, rowt, paget)
    {
      url = urlt;
      if (rowt)  this.setRow(rowt);
      if (paget) this.setPage(paget);
    };
    this.setRow = function(rowt)
    {
      row = rowt;
    };
    this.setPage = function(paget)
    {
      page = paget;
    };
    this.setParameter = function(name, value)
    {
      parameters[name] = value;
    };
    this.clearParameters = function()
    {
      parameters = {};
    };

    function sort(key, order)
    {
      columns.sort(function(a, b) {
        var at = null;
        var bt = null;
        if ((typeof(a[key]) == "number") && (typeof(b[key]) == "number")) {
          at = a[key];
          bt = b[key];
        } else {
          at = a[key] + "";
          bt = b[key] + "";
        }
         if (sortCurrentOrder == "desc") {
          return (bt > at) ? 1 : -1;
        } else {
          return (at > bt) ? 1 : -1;
        }
      });
    };

    this.create = function(key, order)
    {
      if (typeof(this.searchCallback) == "function") {
        this.searchCallback(id);
      }
      if (key) {
        sortCurrentKey = key;
        sortCurrentOrder = (order && (order.toLowerCase() == "desc")) ? "desc" : "asc";
        this.setPage(1);
      }

      if (url) {
        createAjax();
      } else {
        sort(key, order);
        createTable();
      }
    };

    function createTable()
    {
      if (typeof(this.searchComplateCallback) == "function") {
        this.searchComplateCallback(id);
      }

      var div = document.getElementById(id);
      while (div.hasChildNodes()) {
        div.removeChild(div.childNodes[0]);
      }

      var divTable = document.createElement("div");
      divTable.setAttribute(className, self.tableClass);

      if (url) {
        if (row > 0) {
          var divHeader = document.createElement("div");
          divHeader.setAttribute(className, self.headerClass);

          var divLeft = document.createElement("div");
          divLeft.style[floatName] = "right";
          var divRight = document.createElement("div");

          var firstNum = (page-1) * row + 1;
          var endNum   = firstNum + row - 1;
          if (count < endNum) {
            endNum = count;
          }
          divRight.innerHTML = count + " " + firstNum + "-" + endNum + "ɽƤޤ";

          var maxPage = Math.ceil(count/row);
          var start = startPage;
          var end   = endPage;
          if ((start == 0) || (end == 0)) {
            start = 1;
            end   = maxPage;
          }

          var ul = document.createElement("ul");
          ul.style.margin  = "0";
          ul.style.padding = "0";
 
          if (page > 1) {
            var li = document.createElement("li");
            li.style[floatName] = "left";
            li.style.listStyleType = "none";
            var a = document.createElement("a");
            a.href = "javascript:void(0);";
            a.innerHTML = "&lt;&lt;";
            a.onclick = (function(ii){return function(e){
              self.setPage(ii);
              self.create();
            }}).call(null, 1);
            li.appendChild(a);
            ul.appendChild(li);

            var li = document.createElement("li");
            li.style[floatName] = "left";
            li.style.listStyleType = "none";
            var a = document.createElement("a");
            a.href = "javascript:void(0);";
            a.innerHTML = "PREV";
            a.onclick = (function(ii){return function(e){
              self.setPage(ii);
              self.create();
            }}).call(null, page-1);
            li.appendChild(a);
            ul.appendChild(li);
          }
 
          for (var i=start; i<=end; i++) {
            var li = document.createElement("li");
            li.style[floatName] = "left";
            li.style.listStyleType = "none";
            if (i == page) {
              li.setAttribute(className, self.pageActiveClass);
              li.innerHTML = i;
            } else {
              var a = document.createElement("a");
              a.href = "javascript:void(0);";
              a.innerHTML = i;
              a.onclick = (function(ii){return function(e){
                self.setPage(ii);
                self.create();
              }}).call(null, i);
              li.appendChild(a);
            }
            ul.appendChild(li);

            if (i < end) {
              var li = document.createElement("li");
              li.style[floatName] = "left";
              li.style.listStyleType = "none";
              li.innerHTML = "|";
              ul.appendChild(li);
            }
          }

          if (maxPage > page) {
            var li = document.createElement("li");
            li.style[floatName] = "left";
            li.style.listStyleType = "none";
            var a = document.createElement("a");
            a.href = "javascript:void(0);";
            a.innerHTML = "NEXT";
            a.onclick = (function(ii){return function(e){
              self.setPage(ii);
              self.create();
            }}).call(null, page+1);
            li.appendChild(a);
            ul.appendChild(li);

            var li = document.createElement("li");
            li.style[floatName] = "left";
            li.style.listStyleType = "none";
            var a = document.createElement("a");
            a.href = "javascript:void(0);";
            a.innerHTML = "&gt;&gt;";
            a.onclick = (function(ii){return function(e){
              self.setPage(ii);
              self.create();
            }}).call(null, maxPage);
            li.appendChild(a);
            ul.appendChild(li);
          }

          divLeft.appendChild(ul);

          divHeader.appendChild(divLeft);
          divHeader.appendChild(divRight);
          div.appendChild(divHeader);
        }
        divTable.style.clear = "both";
      }

      var table = document.createElement("table");
      var tbody = document.createElement("tbody");
      var tr    = document.createElement("tr");
      tr.setAttribute(className, self.trClass);

      for (var name in headers) {
        var sort  = (headers[name]['sort']) ? headers[name]['sort'] : name;
        var order = headers[name]["order"];
        var th = document.createElement("th");
        var a  = document.createElement("a");
        a.href    = "javascript:void(0);";
        a.onclick = (function(sort, order){return function(e){
          self.create(sort, order);
        }}).call(null, sort, order);
        a.innerHTML = name;
        if (sort == sortCurrentKey) {
          var divOrder = document.createElement("div");
          switch (sortCurrentOrder) {
          case "asc":  divOrder.setAttribute(className, self.thAscClass);  break;
          case "desc": divOrder.setAttribute(className, self.thDescClass); break;
          }
          divOrder.appendChild(a);
          th.appendChild(divOrder);
        } else {
          th.appendChild(a);
        }
        tr.appendChild(th);
      }
      tbody.appendChild(tr);

      for (var i=0; i<columns.length; i++) {
        var tr = document.createElement("tr");
        var trClass = (i%2 == 0) ? self.tr1Class : self.tr2Class;
        tr.setAttribute(className, trClass);
        if (self.trActiveClass) {
          tr.onmouseover = (function(trClass){return function(e){
            this.setAttribute(className, trClass);
          }}).call(null, self.trActiveClass);
          tr.onmouseout = (function(trClass){return function(e){
            this.setAttribute(className, trClass);
          }}).call(null, trClass);
        }

        for (var name in headers) {
          var linkTemplate = headers[name]["linkTemplate"];
          if (linkTemplate) {
            var matches = linkTemplate.match(/\{([^\}]+)\}/g);
            if (matches instanceof Array) {
              for (var j=0; j<matches.length; j++) {
                var match = matches[j].slice(1,-1);
                if (columns[i][match]) {
                  linkTemplate = linkTemplate.replace('{' + match + '}', encodeURIComponent(columns[i][match]));
                }
              }
            }
          }
          var td = document.createElement("td");
          if (linkTemplate) {
            var a = document.createElement("a");
            a.href = linkTemplate;
            a.innerHTML = columns[i][name];
            td.appendChild(a);
          } else {
            td.innerHTML = columns[i][name];
          }
          tr.appendChild(td);
        }
        tbody.appendChild(tr);
      }
      table.appendChild(tbody);
      divTable.appendChild(table);
      div.appendChild(divTable);
    };

    function createAjax()
    {
      headers = [];
      columns = [];

      var params = parameters;
      params['_page'] = page;
      params['_row']  = row;
      if (sortCurrentKey && sortCurrentOrder) {
        params['_sort'] = sortCurrentKey + "." + sortCurrentOrder.toUpperCase();
      }

      SyL.Ajax.Request.sendAsyncPost(url, function(json)
      {
          if (json.status.error) {
            alert(json.status.errorMessage);
            return;
          }
          self.setHeaders(json.header.columns);

          page  = parseInt(json.header.page, 10);
          row   = parseInt(json.header.row, 10);
          count = parseInt(json.header.totalCount, 10);
          startPage = (json.header.startPage) ? parseInt(json.header.startPage, 10) : 0;
          endPage   = (json.header.endPage)   ? parseInt(json.header.endPage, 10)   : 0;

          if (json.header.sort) {
            sortCurrentKey = json.header.sort;
            if (json.header.order) {
              sortCurrentOrder = json.header.order.toLowerCase();
            }
          }
          if (count > 0) {
            for (var i in json.columns) {
              self.addColumns(json.columns[i]);
            }
          }
          createTable();
      }, params);
    };
  }
}
