<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷʸAPIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷʸAPI
 *   http://webservice.rakuten.co.jp/api/auctionitemsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionAuctionItemSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceAuctionAuctionItemSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 
     *
     * @access private
     * @var int
     */
    var $count = 0;
    /**
     * ڡֹ
     *
     * @access private
     * @var int
     */
    var $page = 0;
    /**
     * ڡ⾦ʻ
     *
     * @access private
     * @var int
     */
    var $first = 0;
    /**
     * ڡ⾦ʽ
     *
     * @access private
     * @var int
     */
    var $last = 0;
    /**
     * ҥåȷ
     *
     * @access private
     * @var int
     */
    var $hits = 0;
    /**
     * ꥢ
     *
     * @access private
     * @var int
     */
    var $carrier = 0;
    /**
     * ڡ
     *
     * @access private
     * @var int
     */
    var $page_count = 0;
    /**
     * ʾ
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // 
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/count': $this->count = $text; break;
        // ڡֹ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/page': $this->page = $text; break;
        // ڡ⾦ʻ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/first': $this->first = $text; break;
        // ڡ⾦ʽ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/last': $this->last = $text; break;
        // ҥåȷ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/hits': $this->hits = $text; break;
        // ꥢ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/carrier': $this->carrier = $text; break;
        // ڡ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/pageCount': $this->page_count = $text; break;

        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item': $i++; break;
        // ̾
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemName': $this->items[$i]['itemName'] = $text; break;
        // ʥ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemCode': $this->items[$i]['itemCode'] = $text; break;
        // ʾʸ߲
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemPrice': $this->items[$i]['itemPrice'] = $text; break;
        // 
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/minPrice': $this->items[$i]['minPrice'] = $text; break;
        // ʬ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemCaption': $this->items[$i]['itemCaption'] = $text; break;
        // URL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/itemUrl': $this->items[$i]['itemUrl'] = $text; break;
        // եꥨURL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/affiliateUrl': $this->items[$i]['affiliateUrl'] = $text; break;
        // ʲ̵ͭե饰
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/imageFlag': $this->items[$i]['imageFlag'] = $text; break;
        // ʲ64x64URL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/smallImageUrl': $this->items[$i]['smallImageUrl'] = $text; break;
        // ʲ128x128URL
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/mediumImageUrl': $this->items[$i]['mediumImageUrl'] = $text; break;

        // ¨ե饰
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/blowFlag': $this->items[$i]['blowFlag'] = $text; break;
        // ̥ե饰
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/resultFlag': $this->items[$i]['resultFlag'] = $text; break;
        // 
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/bidCount': $this->items[$i]['bidCount'] = $text; break;
        // ǥե饰
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/taxFlag': $this->items[$i]['taxFlag'] = $text; break;
        // ե饰
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/postageFlag': $this->items[$i]['postageFlag'] = $text; break;
        // 쥸åȥѲǽե饰
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/creditCardFlag': $this->items[$i]['creditCardFlag'] = $text; break;
        // եꥨΨ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/affiliateRate': $this->items[$i]['affiliateRate'] = $text; break;
        // 䳫ϻ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/startTime': $this->items[$i]['startTime'] = $text; break;
        // 佪λ
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/endTime': $this->items[$i]['endTime'] = $text; break;
        // ʼ̾
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/shopName': $this->items[$i]['shopName'] = $text; break;
        // ʼԼ̥ե饰
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/shopStatusFlag': $this->items[$i]['shopStatusFlag'] = $text; break;
        // ID
        case '/Response/Body/auctionItemSearch:AuctionItemSearch/Items/Item/genreId': $this->items[$i]['genreId'] = $text; break;

        // 嵭ʳ
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 
     *
     * @access public
     * @return int 
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * ڡֹ
     *
     * @access public
     * @return int 
     */
    function getPage()
    {
        return $this->page;
    }

    /**
     * ڡ⾦ʻ֤
     *
     * @access public
     * @return int 
     */
    function getFirst()
    {
        return $this->first;
    }

    /**
     * ڡ⾦ʽ֤
     *
     * @access public
     * @return int 
     */
    function getLast()
    {
        return $this->last;
    }

    /**
     * ꥢ
     *
     * @access public
     * @return int 
     */
    function getCarrier()
    {
        return $this->carrier;
    }

    /**
     * ڡ
     *
     * @access public
     * @return int 
     */
    function getPageCount()
    {
        return $this->page_count;
    }

    /**
     * ʾ
     *
     * @access public
     * @return array ʾ
     */
    function getItems()
    {
        return $this->items;
    }

}

?>
