<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceYahoo_co_jp.php,v 1.5 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥꥯȥ饹Yahoo! Japan
 */
require_once dirname(__FILE__) . '/Yahoo_co_jp/SyL_WebServiceYahoo_co_jpRequest.php';
/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan
 */
require_once dirname(__FILE__) . '/Yahoo_co_jp/SyL_WebServiceYahoo_co_jpResponse.php';

/**
 * WEBӥ饹Yahoo! Japanѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceYahoo_co_jp.php,v 1.5 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceYahoo_co_jp extends SyL_WebService
{
    // -----------------------------------------------------
    // Yahoo!
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʥָѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥָѡ
     */
    function &createSearchWebRequest()
    {
        $class_name = 'SyL_WebServiceSearchWebRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Web/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʲѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʲѡ
     */
    function &createSearchImageRequest()
    {
        $class_name = 'SyL_WebServiceSearchImageRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Image/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥư踡ѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡư踡ѡ
     */
    function &createSearchVideoRequest()
    {
        $class_name = 'SyL_WebServiceSearchVideoRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Video/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʴϢѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʴϢѡ
     */
    function &createSearchWebunitRequest()
    {
        $class_name = 'SyL_WebServiceSearchWebunitRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Search/Webunit/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!ƥ
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʥǥ쥯ȥĥ꡼ѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥǥ쥯ȥĥ꡼ѡ
     */
    function &createCategoryBrowseRequest()
    {
        $class_name = 'SyL_WebServiceCategoryBrowseRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Category/Browse/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʥǥ쥯ȥꥵѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥǥ쥯ȥꥵѡ
     */
    function &createCategorySearchRequest()
    {
        $class_name = 'SyL_WebServiceCategorySearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Category/Search/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʥ - ƥѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥ - ƥѡ
     */
    function &createAuctionCategoryTreeRequest()
    {
        $class_name = 'SyL_WebServiceAuctionCategoryTreeRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/CategoryTree/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʥ - ʥꥹѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥ - ʥꥹѡ
     */
    function &createAuctionCategoryLeafRequest()
    {
        $class_name = 'SyL_WebServiceAuctionCategoryLeafRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/CategoryLeaf/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʥ - ʥꥹѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥ - ʥꥹѡ
     */
    function &createAuctionSellingListRequest()
    {
        $class_name = 'SyL_WebServiceAuctionSellingListRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/SellingList/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʥ - ѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥ - ѡ
     */
    function &createAuctionSearchRequest()
    {
        $class_name = 'SyL_WebServiceAuctionSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/Search/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʥ - ʾܺѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥ - ʾܺѡ
     */
    function &createAuctionAuctionItemRequest()
    {
        $class_name = 'SyL_WebServiceAuctionAuctionItemRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Auction/AuctionItem/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!ߥ塼å
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʥɥơȥꥹѡ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥɥơȥꥹѡ
     */
    function &createMusicStationRequest()
    {
        $class_name = 'SyL_WebServiceMusicStationRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Music/Station/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!Ͽ޾
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥ȤϿ޾ - 륵API
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡϿ޾ - 륵API
     */
    function &createMapLocalSearchRequest()
    {
        $class_name = 'SyL_WebServiceMapLocalSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Map/LocalSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // ƥȲ
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥ȤܸǲWebӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡܸǲWebӥ
     */
    function &createJlpMAServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpMAServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/MAService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʤʴѴWebӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʤʴѴWebӥ
     */
    function &createJlpJIMServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpJIMServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/JIMService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʹٱWebӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʹٱWebӥ
     */
    function &createJlpKouseiServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpKouseiServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/KouseiService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʥӿWebӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥӿWebӥ
     */
    function &createJlpFuriganaServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpFuriganaServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/FuriganaService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥܸ췸Webӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡܸ췸Webӥ
     */
    function &createJlpDAServiceRequest()
    {
        $class_name = 'SyL_WebServiceJlpDAServiceRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/DAService/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʻƻ췸踡Webӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʻƻ췸踡Webӥ
     */
    function &createJlpDAServiceSearchRequest()
    {
        $class_name = 'SyL_WebServiceJlpDAServiceSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Jlp/DAServiceSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!ťʥ
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʸ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʸ
     */
    function &createKadenProductSearchRequest()
    {
        $class_name = 'SyL_WebServiceKadenProductSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Kaden/ProductSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʾ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʾ
     */
    function &createKadenProductItemRequest()
    {
        $class_name = 'SyL_WebServiceKadenProductItemRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Kaden/ProductItem/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!˥塼
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʥ˥塼 - ȥԥåAPI
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʥ˥塼 - ȥԥåAPI
     */
    function &createNewsTopicsRequest()
    {
        $class_name = 'SyL_WebServiceNewsTopicsRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/News/Topics/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!ߤʤθ
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʤߤʤθ ꥹWebӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʤߤʤθ ꥹWebӥ
     */
    function &createMinnaCertCertListRequest()
    {
        $class_name = 'SyL_WebServiceMinnaCertCertListRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/MinnaCert/CertList/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʤߤʤθ ܺWebӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʤߤʤθ ܺWebӥ
     */
    function &createMinnaCertCertDetailRequest()
    {
        $class_name = 'SyL_WebServiceMinnaCertCertDetailRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/MinnaCert/CertDetail/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʤߤʤθ Webӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡʤߤʤθ Webӥ
     */
    function &createMinnaCertCertExamRequest()
    {
        $class_name = 'SyL_WebServiceMinnaCertCertExamRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/MinnaCert/CertExam/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    // -----------------------------------------------------
    // Yahoo!η
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥ȤYahoo!η: 両Webӥ
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡYahoo!η: 両Webӥ
     */
    function &createChiebukuroQuestionSearchRequest()
    {
        $class_name = 'SyL_WebServiceChiebukuroQuestionSearchRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Chiebukuro/QuestionSearch/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤYahoo!η: ƥĥ꡼
     * 
     * @access public
     * @return object WEBӥꥯȥ֥ȡYahoo!η: ƥĥ꡼
     */
    function &createChiebukuroCategoryTreeRequest()
    {
        $class_name = 'SyL_WebServiceChiebukuroCategoryTreeRequest';
        include_once dirname(__FILE__) . '/Yahoo_co_jp/Chiebukuro/CategoryTree/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }
}

?>
