<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ߤʤθ ܺWebӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ߤʤθ ܺWebӥ
 *   http://developer.yahoo.co.jp/minna_cert/certdetail/V1/certdetail.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertDetailResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMinnaCertCertDetailResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡΥޥå꡼
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * ̤κǽΥݥ
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * ǡ
     *
     * @access private
     * @var array
     */
    var $result = array();
    /**
     * ǡ
     *
     * @access private
     * @var array
     */
    var $questions = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i   = -1;
        static $q_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;
        // ID
        case '/ResultSet/Result/CertId': $this->result['CertId'] = $text; break;
        // ̾
        case '/ResultSet/Result/CertName': $this->result['CertName'] = $text; break;
        // URL
        case '/ResultSet/Result/CertImageUrl': $this->result['CertImageUrl'] = $text; break;
        // 공
        case '/ResultSet/Result/CertOverview': $this->result['CertOverview'] = $text; break;
        // θ
        case '/ResultSet/Result/OpenDate': $this->result['OpenDate'] = $text; break;
        // 
        case '/ResultSet/Result/QuestionCount': $this->result['QuestionCount'] = $text; break;
        // ʴ
        case '/ResultSet/Result/Correct': $this->result['Correct'] = $text; break;
        // 
        case '/ResultSet/Result/ExamAmount': $this->result['ExamAmount'] = $text; break;
        // ʼ
        case '/ResultSet/Result/PassAmount': $this->result['PassAmount'] = $text; break;
        // θϿѼԤο
        case '/ResultSet/Result/FavoredCertCount': $this->result['FavoredCertCount'] = $text; break;
        // Ƥ줿ȿ
        case '/ResultSet/Result/CommentCount': $this->result['CommentCount'] = $text; break;
        // ɾݥȤʿ
        case '/ResultSet/Result/EvalPoint': $this->result['EvalPoint'] = $text; break;
        // ݥ
        case '/ResultSet/Result/TotalPoint': $this->result['TotalPoint'] = $text; break;
        // ѥǤθܺ٥ڡURL
        case '/ResultSet/Result/CertDetailPcUrl': $this->result['CertDetailPcUrl'] = $text; break;
        // ХǤθܺ٥ڡURL
        case '/ResultSet/Result/CertDetailMbUrl': $this->result['CertDetailMbUrl'] = $text; break;

        case '/ResultSet/Result/QuestionResult/QuestionData': $i++; break;
        // ID
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionId': $this->questions[$i]['QuestionId'] = $text; break;
        // ֹ
        case '/ResultSet/Result/QuestionResult/QuestionData/OrderNumber': $this->questions[$i]['OrderNumber'] = $text; break;
        // ʸ
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionText': $this->questions[$i]['QuestionText'] = $text; break;
        // MˤURL
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionImageMUrl': $this->questions[$i]['QuestionImageMUrl'] = $text; break;
        // SˤURL
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionImageSUrl': $this->questions[$i]['QuestionImageSUrl'] = $text; break;
        // 
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult':
            $this->questions[$i]['ChoicesResult'] = array();
            $q_i = -1;
            break;
        // ƾ
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData': $q_i++; break;
        // ֹ
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData/OrderNumber': $this->questions[$i]['ChoicesResult'][$q_i]['OrderNumber'] = $text; break;
        // 
        case '/ResultSet/Result/QuestionResult/QuestionData/ChoicesResult/ChoiceData/ChoiceText': $this->questions[$i]['ChoicesResult'][$q_i]['ChoiceText'] = $text; break;
        // 򤷤ͤ
        case '/ResultSet/Result/QuestionResult/QuestionData/CorrectCountTotal': $this->questions[$i]['CorrectCountTotal'] = $text; break;
        // ֹ
        case '/ResultSet/Result/QuestionResult/QuestionData/CorrectAnswer': $this->questions[$i]['CorrectAnswer'] = $text; break;
        // ʸ
        case '/ResultSet/Result/QuestionResult/QuestionData/QuestionExplanation': $this->questions[$i]['QuestionExplanation'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * ǡ
     *
     * @access public
     * @return array ǡ
     */
    function getResult()
    {
        return $this->result;
    }

    /**
     * ǡ
     *
     * @access public
     * @return array ǡ
     */
    function getQuestions()
    {
        return $this->questions;
    }
}

?>
