<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.1 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륷ƥ९饹
 */
SyL_Loader::lib('Filesystem');

/**
 * å饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.1 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Index extends AppAction
{
    /**
     * ᥤ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();
        // С󥳥ޥ
        if ($data->is('h') || $data->is('help')) {
            $this->displayHelp($cmd, $data->get(0));
            return;
        // إץޥ
        } else if ($data->is('v') || $data->is('version')) {
            $this->displayVersion($cmd, $data->get(0));
            return;
        }

        $type        = strtolower($data->get(1));
        $project_dir = $data->geta('d', 0);
        $app_name    = $data->geta('w', 0);

        // ץå
        switch ($type) {
        case 'all':
            $app_name = null;
        case 'cache':
        case 'smarty':
            break;
        default:
            $this->displayDefault($cmd, $data->get(0));
            return;
        }

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        if (!$project_dir) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }
        if (!preg_match('/(\\\\|\/)$/', $project_dir)) {
            $project_dir .= '/';
        }
        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        if ($app_name !== null) {
            $app_dir = "{$project_dir}apps/{$app_name}/";
            if (!file_exists($app_dir)) {
                trigger_error("[SyL error] Invalid application. Application directory not found ({$app_dir})", E_USER_ERROR);
                exit;
            }
        }

        switch ($type) {
        case 'cache':
            $this->removeCache($project_dir, $app_name);
            break;
        case 'smarty':
            $this->removeSmarty($project_dir, $app_name);
            break;
        case 'all':
            $this->removeCache($project_dir, $app_name);
            $this->removeSmarty($project_dir, $app_name);
            break;
        }
    }

    /**
     * å
     *
     * @access private
     * @param string ץȥѥ
     * @param string ץꥱ̾
     */
    function removeCache($project_dir, $app_name)
    {
        if ($app_name !== null) {
            $app_dir = "{$project_dir}var/cache/{$app_name}";
            $remove_dirs = array();
            $remove_dirs[] = "{$app_dir}/config/";
            $remove_dirs[] = "{$app_dir}/app/";
            foreach ($remove_dirs as $remove_dir) {
                if (is_dir($remove_dir)) {
                    $dir =& SyL_Filesystem::factory($remove_dir);
                    $dir->delete();

                    $dir =& SyL_Filesystem::factory($app_dir);
                    $dir->createDirectory(basename($remove_dir), 0777);
                }
            }
        } else {
            foreach ($this->getAppNames($project_dir) as $dir_name) {
                $this->removeCache($project_dir, $dir_name);
            }
        }
    }

    /**
     * Smartyƥץ졼ȥå
     *
     * @access private
     * @param string ץȥѥ
     * @param string ץꥱ̾
     */
    function removeSmarty($project_dir, $app_name)
    {
        if ($app_name !== null) {
            // եå
            $project_config_file = "{$project_dir}config/defines.xml";
            $app_config_file     = "{$project_dir}apps/{$app_name}/config/defines.xml";

            if (!is_file($project_config_file)) {
                trigger_error("[SyL error] `defines.xml' not found in project directory({$project_config_file})", E_USER_ERROR);
            }

            // ե
            $config =& SyL_Config::factory('defines');
            $config->setConfigFiles(array($app_config_file, $project_config_file));
            $config->parseXml(false, false);
            $values = $config->getConfig();

            if (!isset($values['SYL_SMARTY_PARAMETER']) || !$values['SYL_SMARTY_PARAMETER']) {
                trigger_error("[SyL error] `SYL_SMARTY_PARAMETER' constant not defined in config file({$project_config_file} or {$app_config_file})", E_USER_ERROR);
            }

            $remove_dirs = array();
            foreach (explode(';', $values['SYL_SMARTY_PARAMETER']) as $parameter) {
                $values = explode('=', $parameter, 2);
                switch ($values[0]) {
                case 'compile_dir':
                case 'cache_dir':
                    $tmp = $values[1];
                    $tmp = str_replace('{SYL_PROJECT_DIR}', $project_dir, $tmp);
                    $tmp = str_replace('{SYL_APP_NAME}', $app_name, $tmp);
                    $remove_dirs[] = $tmp;
                    break;
                }
            }
            if (count($remove_dirs) == 0) {
                return;
            }

            foreach ($remove_dirs as $remove_dir) {
                if (is_dir($remove_dir)) {
                    $dir =& SyL_Filesystem::factory($remove_dir);
                    $dir->delete();

                    $current_dir = dirname($remove_dir);
                    $create_name = basename($remove_dir);
                    $dir =& SyL_Filesystem::factory($current_dir);
                    $dir->createDirectory($create_name, 0777);
                }
            }
        } else {
            foreach ($this->getAppNames($project_dir) as $dir_name) {
                $this->removeSmarty($project_dir, $dir_name);
            }
        }
    }

    /**
     * ץץꥱ̾
     *
     * @access private
     * @param string ץȥѥ
     * @param array ץꥱ̾
     */
    function getAppNames($project_dir)
    {
        $cache_dir = "{$project_dir}var/cache/";
        $dir_names = array();

        $dir =& SyL_Filesystem::factory($cache_dir);
        $dir->createTree();
        foreach ($dir->getList() as $element) {
            $dir_names[] = basename($element->getName());
        }
        return $dir_names;
    }

    /**
     * إפɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayHelp(&$cmd, $file)
    {
        $help = <<<EOF
Usage:
  php {$file} cache -d <dir> [-w <name>]
  php {$file} smarty -d <dir> [-w <name>]
  php {$file} all -d <dir> [-w <name>]
  php {$file} [option]

Options:
  -d <dir>  project directory
  -w <name> application name
  -h        show this help, then exit
  -v        output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayVersion(&$cmd, $file)
    {
        $syl_version = SYL_VERSION;
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$syl_version} (PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (C) 2006-2008 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayDefault(&$cmd, $file)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
