<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륷ƥ९饹
 */
SyL_Loader::lib('Filesystem');
/**
 * ̥饹
 */
SyL_Loader::lib('Compress');

/**
 * å饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Index extends AppAction
{
    /**
     * ᥤ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();
        // С󥳥ޥ
        if ($data->is('h') || $data->is('help')) {
            $this->displayHelp($cmd, $data->get(0));
            return;
        // إץޥ
        } else if ($data->is('v') || $data->is('version')) {
            $this->displayVersion($cmd, $data->get(0));
            return;
        }

        $type        = strtolower($data->get(1));
        $project_dir = $data->geta('d', 0);
        $app_name    = $data->geta('w', 0);
        $category_name  = $data->geta('c', 0);
        $output_dir     = $data->geta('o', 0);
        $category_only  = $data->is('n');
        $remove_log     = $data->is('r');
        $start_datetime = $data->geta('s', 0);
        $start_date     = null;
        $end_datetime   = $data->geta('e', 0);
        $end_date       = null;

        // ץå
        $syslog = false;
        switch ($type) {
        case 'view':
        case 'archive':
        case 'remove':
            $syslog = false;
            break;
        case 'sysview':
        case 'sysarchive':
        case 'sysremove':
            $syslog = true;
            break;
        default:
            $this->displayDefault($cmd, $data->get(0));
            return;
        }

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        if (!$project_dir) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }
        if (!preg_match('/(\\\\|\/)$/', $project_dir)) {
            $project_dir .= '/';
        }
        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        if (!$app_name) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        }
        $app_dir = "{$project_dir}apps/{$app_name}/";
        if (!file_exists($app_dir)) {
            trigger_error("[SyL error] Invalid application. Application directory not found ({$app_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // å
        // -------------------------------------------------
        if ($start_datetime !== null) {
            $tmp = strtotime($start_datetime);
            if (($tmp === false) || ($tmp === -1)) {
                trigger_error("[SyL error] Invalid start datetime (-s). Not `strtotime' format ({$start_datetime})", E_USER_ERROR);
                exit;
            }
            $start_datetime = $tmp;
            $start_date = mktime(0, 0, 0, date('n', $start_datetime), date('j', $start_datetime), date('Y', $start_datetime));
        }

        // -------------------------------------------------
        // λå
        // -------------------------------------------------
        if ($end_datetime !== null) {
            $tmp = strtotime($end_datetime);
            if (($tmp === false) || ($tmp === -1)) {
                trigger_error("[SyL error] Invalid end datetime (-e). Not `strtotime' format ({$end_datetime})", E_USER_ERROR);
                exit;
            }
            $end_datetime = $tmp;
            $end_date = mktime(23, 59, 59, date('n', $end_datetime), date('j', $end_datetime), date('Y', $end_datetime));
        }

        // -------------------------------------------------
        // ե뤫
        // -------------------------------------------------
        $logfile = '';
        if ($syslog) {
            $logfile = "{$project_dir}/var/syslogs/{$app_name}/phperror_{YYYY}{MM}{DD}.log";
        } else {
            $project_config_file = "{$project_dir}config/defines.xml";
            $app_config_file     = "{$project_dir}apps/{$app_name}/config/defines.xml";

            if (!is_file($project_config_file)) {
                trigger_error("[SyL error] `defines.xml' not found in project directory({$project_config_file})", E_USER_ERROR);
            }

            // ե
            $config =& SyL_Config::factory('defines');
            $config->setConfigFiles(array($app_config_file, $project_config_file));
            $config->parseXml(false, false);
            $values = $config->getConfig();

            if (!isset($values['SYL_LOG_FILE']) || !$values['SYL_LOG_FILE']) {
                trigger_error("[SyL error] `SYL_LOG_FILE' constant not defined in config file({$project_config_file} or {$app_config_file})", E_USER_ERROR);
            }
            $logfile = $values['SYL_LOG_FILE'];
            $logfile = str_replace('{SYL_PROJECT_DIR}', $project_dir, $logfile);
            $logfile = str_replace('{SYL_APP_NAME}',    $app_name,    $logfile);
        }

        $logfile_dir  = dirname($logfile);
        $logfile_name = preg_quote(basename($logfile));
        $logfile_name = str_replace('\\{YYYY\\}', '\\d{4}', $logfile_name);
        $logfile_name = str_replace('\\{MM\\}',   '\\d{2}', $logfile_name);
        $logfile_name = str_replace('\\{DD\\}',   '\\d{2}', $logfile_name);
        $logfile_name_reg = '/^' . $logfile_name . '(\.gz)?$/';

        // -------------------------------------------------
        // оݥեե륿
        // -------------------------------------------------
        $logfiles = array();
        $dir =& SyL_Filesystem::factory($logfile_dir);
        $dir->createTree();
        foreach ($dir->getList() as $element) {
            // ֥ե륿
            $mtime = $element->getMtime();
            if ($start_date && ($mtime < $start_date)) continue;
            if ($end_date && ($mtime > $end_date)) continue;
            // ե̾ե륿
            $filename = $element->getName();
            if (!preg_match($logfile_name_reg, basename($filename))) continue;
            $logfiles[] = $filename;
        }

        // -------------------------------------------------
        // ޥʬ
        // -------------------------------------------------
        switch ($type) {
        case 'archive':
        case 'sysarchive':
            // ϥǥ쥯ȥå
            if ($output_dir) {
                if (!is_dir($output_dir)) {
                    trigger_error("[SyL error] Invalid output_dir (-o) ({$output_dir})", E_USER_ERROR);
                    exit;
                }
            } else {
                $output_dir = $logfile_dir;
            }
            $this->archiveLog($cmd, $logfiles, $output_dir, $remove_log);
            break;
        case 'view':
        case 'sysview':
            // ƥ̾å
            if ($category_name !== null) {
                switch ($category_name) {
                case 'error':
                case 'warn':
                case 'notice':
                case 'info':
                case 'debug':
                    break;
                default:
                  trigger_error("[SyL error] Invalid category name (-c). {error|warn|notice|info|debug} ({$category_name})", E_USER_ERROR);
                  exit;
                }
            }
            $this->viewLog($cmd, $syslog, $logfiles, $category_name, $category_only, $start_datetime, $end_datetime);
            break;
        case 'remove':
        case 'sysremove':
            $this->removeLog($cmd, $logfiles);
            break;
        }
    }

    /**
     * 򰵽̤
     *
     * @access private
     * @param object ޥɥ֥
     * @param array ե
     * @param string ̥եϥǥ쥯ȥ
     * @param bool ̸եե饰
     */
    function archiveLog(&$cmd, $logfiles, $output_dir, $remove_log)
    {
        foreach ($logfiles as $logfile) {
            $output_file = $output_dir . '/' . basename($logfile) . '.gz';
            SyL_Compress::compressFromFile('gzip', $logfile, $output_file, $remove_log);
            $cmd->stdout("{$logfile} -> {$output_file}");
        }
    }

    /**
     * Ƥɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param bool PHPƥե饰
     * @param array ե
     * @param string ƥ̾
     * @param bool ꥫƥΤɽե饰
     * @param string 
     * @param string λ
     */
    function viewLog(&$cmd, $syslog, $logfiles, $category_name, $category_only, $start_datetime, $end_datetime)
    {
        $reg = '';
        if ($syslog) {
            $reg = '/^\[([^\]]+)\] PHP.* (error|Warning|Notice): .+/';
        } else {
            $reg = '/^(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}) \[[^\]]+:([^\]]+)\] .+/';
        }

        $categories = array(
            'none'   => SYL_LOG_NONE,
            'error'  => SYL_LOG_ERROR,
            'warn'   => SYL_LOG_WARN,
            'notice' => SYL_LOG_NOTICE,
            'info'   => SYL_LOG_INFO,
            'debug'  => SYL_LOG_DEBUG,
         );
        $current_category = $category_name ? $categories[$category_name] : null;

        foreach ($logfiles as $logfile) {
            $fp = null;
            if (preg_match('/\.gz$/', $logfile)) {
                $fp = fopen("compress.zlib://{$logfile}", 'rb');
            } else {
                $fp = fopen($logfile, 'rb');
            }
            $line = '';
            $tmp_category = '';
            while (!feof($fp)) {
                $tmp = fgets($fp);
                if (preg_match($reg, $tmp, $matches)) {
                    if ($line) {
                        $cmd->stdout(rtrim($line));
                    }
                    
                    $skip = false;
                    $current_datetime = strtotime($matches[1]);
                    if ($start_datetime && ($current_datetime < $start_datetime)) {
                        $skip = true;
                    }
                    if ($end_datetime && ($current_datetime > $end_datetime)) {
                        $skip = true;
                    }

                    if (!$skip) {
                        // syslog
                        $matches[2] = strtolower($matches[2]);
                        if ($matches[2] == 'warning') {
                            $matches[2] = 'warn';
                        }
                        if (!$current_category) {
                            $line = $tmp;
                        } else if ($category_only && ($categories[$matches[2]] == $current_category)) {
                            $line = $tmp;
                        } else if (!$category_only && ($categories[$matches[2]] <= $current_category)) {
                            $line = $tmp;
                        } else {
                            $skip = true;
                        }
                    }

                    if ($skip) {
                        $line = '';
                    }
                } else {
                    if ($line) {
                        $line .= $tmp;
                    }
                }
            }
            if ($line) {
                $cmd->stdout(rtrim($line));
            }
            fclose($fp);
        }
    }

    /**
     * 
     *
     * @access private
     * @param object ޥɥ֥
     * @param array ե
     */
    function removeLog(&$cmd, $logfiles)
    {
        foreach ($logfiles as $logfile) {
            if (unlink($logfile)) {
                $cmd->stdout("remove: {$logfile}");
            }
        }
    }

    /**
     * إפɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayHelp(&$cmd, $file)
    {
        $help = <<<EOF
Usage:
  php {$file} view -d <dir> -w <name> [-c <name>] [-n] [-s <datetime>] [-e <datetime>]
  php {$file} archive -d <dir> -w <name> [-o <dir>] [-r] [-s <datetime>] [-e <datetime>]
  php {$file} remove -d <dir> -w <name> [-s <datetime>] [-e <datetime>]
  php {$file} sysview -d <dir> -w <name> [-c <name>] [-n] [-s <datetime>] [-e <datetime>]
  php {$file} sysarchive -d <dir> -w <name> [-o <dir>] [-r] [-s <datetime>] [-e <datetime>]
  php {$file} sysremove -d <dir> -w <name> [-s <datetime>] [-e <datetime>]
  php {$file} [option]

Options:
  -d <dir>      project directory
  -w <name>     application name
  -c <name>     log category name (default: all category)
  -n            category only (default: more than category)
  -o <dir>      archive output directory (default: log file directory)
  -r            remove archived log file (default: not remove)
  -s <datetime> start datetime (strtotime format) (default: none)
  -e <datetime> end datetime (strtotime format) (default: none)
  -h            show this help, then exit
  -v            output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayVersion(&$cmd, $file)
    {
        $syl_version = SYL_VERSION;
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$syl_version} (PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (C) 2006-2008 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayDefault(&$cmd, $file)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
