<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowLst.php,v 1.12 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowLst.php,v 1.12 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowLst extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'lst';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowLst()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ɽե
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // ѥ᡼
        $page  = $data->get('_page');
        $row   = $data->get('_row');
        $sort  = $data->get('_sort');
        $index = $data->get('adm_list_index'); // AjaxξΤ߻

        // ɽȽ
        if (!is_numeric($row) || ($row < 1)) {
            $row = '';
        }

        // ե
        $form =& $this->getForm();
        // ǡ֥ȥå
        $form->registerInput($data);
        // ե๽
        $form->buildSearch();

        // DB³
        $conn =& $context->getDB();

        // ADM֥Ⱥ
        $adm =& SyL_Adm::factory($form, $conn);
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isLst()) {
            // Բ
            echo '<h2>403 Forbidden</h2>';
            exit;
        }

        // ɽǡ
        $results = $adm->getList($sort, $page, $row);
        // Ȥθѥ᡼
        $search_parameter = implode('&', $adm->getSearchParameters());
        // إåɽܼ
        $headers = $adm->getSelectHeaders();
        // ȤΥȹܼ
        $current_sort = $adm->getSortColumns();

        // ڡ֥ȼ
        $pager =& $adm->getPager();
        // 󥯥ڡϰϼ
        $links        = $adm->getPageLinks($pager, $form->getStructConfig('link_range'));
        $current_page = $pager->getCurrentPage();
        $max_page     = $pager->getTotalPage();

        // ǥեȸɽ
        $search_view = $adm->isDefaultSearchView();

        // DB³λ
        $context->closeDB($conn);

        // ץ饤ޥꥭ
        $primaries    = $adm->getPrimary(false);
        $primary_name = '';
        if (count($primaries) > 0) {
            $primary_name = $primaries[0];
        }
        // ץ饤ޥ꡼󥯥ѥ᡼
        $primary_link_parameters = $adm->getPrimaryLinkParameters($results);

        // 󥯼
        if ($search_parameter != '') {
            $search_parameter = '&' . $search_parameter;
            $search_view  = true;
        }

        // եǥǡϢ
        $data->set('form', $form->getResultArray());
        $data->set('search_view', $search_view);

        // ɽǡϢ
        $data->set('headers', $headers);
        $data->set('results', $results);

        // 祭ѥ᡼
        $data->set('key_name',     $form->getStructConfig('key_name'));
        $data->set('primary_name', $primary_name);
        $data->set('primary_link_parameters', $primary_link_parameters);

        // ڡ󥯴Ϣѥ᡼
        $data->set('links',        $links);
        $data->set('max_page',     $max_page);
        $data->set('current_page', $current_page);
        $data->set('current_sort', $current_sort);
        $data->set('search_parameter', $search_parameter);

       // ǧɽϢ
        $data->set('view_alert', $form->getStructConfig('view_alert'));

        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_new', $this->getUrl('new'));
        $data->set('url_upd', $this->getUrl('upd'));
        $data->set('url_vew', $this->getUrl('vew'));
        $data->set('url_del', $this->getUrl('del'));
        $data->set('url_dir', dirname($this->getScriptName()));

        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // Ͽǽե饰
        $data->set('enable_new', $adm->isNew());
        // Խǽե饰
        $data->set('enable_upd', $adm->isUpd());
        // ǽե饰
        $data->set('enable_del', $adm->isDel());
        // Ȳǽե饰
        $data->set('enable_vew', $adm->isVew());

        // AjaxΤߡϢ󥯥ǥå
        $data->set('index', $index);
    }

    /**
     * Ajax饤֥ѥ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function executeImport(&$data, &$context)
    {
        $data->addImport('ajax');
        $context->setViewType('js.default');
    }

    /**
     * JSONѥ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function executeJson(&$data, &$context)
    {
        $data->apply('mb_convert_encoding', SYL_ENCODE_INTERNAL, SYL_ENCODE_JS);

        // ѥ᡼
        $page = $data->get('_page');
        $row  = $data->get('_row');
        $sort = $data->get('_sort');

        // ɽȽ
        if (!is_numeric($row) || ($row < 1)) {
            $row = '';
        }

        // ե
        $form =& $this->getForm();
        // ǡ֥ȥå
        $form->registerInput($data);
        // ե๽
        $form->buildSearch();

        // DB³
        $conn =& $context->getDB();

        // ADM֥Ⱥ
        $adm =& SyL_Adm::factory($form, $conn);
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isLst()) {
            $status = array(
              'error' => true,
              'errorMessage' => '403 Forbidden'
            );
            $data->set('status',  $status);
            $data->set('header',  array());
            $data->set('columns', array());
            $data->apply('mb_convert_encoding', SYL_ENCODE_JS, SYL_ENCODE_INTERNAL);
            $context->setViewType('json');
            return;
        }
        // ɽǡ
        $results = $adm->getList($sort, $page, $row);

        // DB³λ
        $context->closeDB($conn);

        // إåɽܼ
        $columns = $adm->getSelectHeaders();
        // ȤΥȹܼ
        list($current_sort) = explode(',', $adm->getSortColumns());
        $pos = strrpos($current_sort, '.');
        $current_order = substr($current_sort, $pos+1);
        $current_sort  = substr($current_sort, 0, $pos);

        // ڡ֥ȼ
        $pager =& $adm->getPager();
        $range = $form->getStructConfig('link_range');
        $start_page = 0;
        $end_page   = 0;
        if (is_numeric($range)) {
            list($start_page, $end_page) = $pager->getRange($range);
        } else {
            if ($pager->getCurrentPage() > 0) {
                $start_page = 1;
                $end_page   = $pager->getTotalPage();
            }
        }

        // ץ饤ޥꥭ
        $primarys = $adm->getPrimary(false);
        $key = $form->getStructConfig('key_name');
        foreach ($columns as $name => $values) {
            $columns[$name]['sort'] = substr($values['sortlink'], 0, strrpos($values['sortlink'], '.'));
            unset($columns[$name]['sortlink']);
            if ((count($primarys) > 0) && ($primarys[0] == $name)) {
                $link_params = array();
                foreach ($primarys as $primary) {
                    $link_params[] = $primary . '%3D{' . $primary . '}';
                }
                $columns[$name]['linkTemplate'] = $this->getUrl('vew') . '?' . $key . '=' . implode('%09', $link_params);
            }
        }

        $status = array(
          'error' => false,
          'errorMessage' => ''
        );

        $headers = array(
          'page'       => $pager->getCurrentPage(),
          'startPage'  => $start_page,
          'endPage'    => $end_page,
          'row'        => $pager->getCount(),
          'totalPage'  => $pager->getTotalPage(),
          'totalCount' => $pager->getCountAll(),
          'columns'    => $columns,
          'sort'       => $current_sort,
          'order'      => $current_order,
        );

        $data->set('status',  $status);
        $data->set('header',  $headers);
        $data->set('columns', $results);
        $data->apply('mb_convert_encoding', SYL_ENCODE_JS, SYL_ENCODE_INTERNAL);
        $context->setViewType('json');
    }
}

?>
