<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceRequest.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ܸǲWebӥ
 */
require_once 'SyL_WebServiceJlpMAServiceResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ܸǲWebӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ܸǲWebӥ
 *   http://developer.yahoo.co.jp/jlp/MAService/V1/parse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceRequest.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceJlpMAServiceRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'jlp.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/MAService/V1/parse';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceJlpMAServiceResponse';

    /**
     * оݤΥƥȤ򥻥åȤ
     *
     * @access public
     * @param string оݤΥƥ
     */
    function setSentence($sentence)
    {
        parent::set('sentence', $sentence);
    }

    /**
     * Ϸ̤μ򥻥åȤ
     *
     * @access public
     * @param string Ϸ̤μ
     */
    function setResults($results)
    {
        foreach (array_map('trim', explode(',', $results)) as $tmp) {
            switch ($tmp) {
            case 'ma':
            case 'uniq':
                break;
            default:
                trigger_error("[SyL error] Invalid `results' property ({$results}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('results', $results);
    }

    /**
     * ma_response, uniq_response Υǥե򥻥åȤ
     *
     * @access public
     * @param string ma_response, uniq_response Υǥե
     */
    function setResponse($response)
    {
        foreach (array_map('trim', explode(',', $response)) as $tmp) {
            switch ($tmp) {
            case 'surface':
            case 'reading':
            case 'pos':
            case 'baseform':
            case 'feature':
                break;
            default:
                trigger_error("[SyL error] Invalid `response' property ({$response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('response', $response);
    }

    /**
     * ma_filter, uniq_filter Υǥե򥻥åȤ
     *
     * @access public
     * @param string ma_filter, uniq_filter Υǥե
     */
    function setFilter($filter)
    {
        foreach (array_map('trim', explode('|', $filter)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '10':
            case '11':
            case '12':
            case '13':
                break;
            default:
                trigger_error("[SyL error] Invalid `filter' property ({$filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('filter', $filter);
    }

    /**
     * ma_result  word ֤Ǿ򥻥åȤ
     *
     * @access public
     * @param string ma_result  word ֤Ǿ
     */
    function setMa_response($ma_response)
    {
        foreach (array_map('trim', explode(',', $ma_response)) as $tmp) {
            switch ($tmp) {
            case 'surface':
            case 'reading':
            case 'pos':
            case 'baseform':
            case 'feature':
                break;
            default:
                trigger_error("[SyL error] Invalid `ma_response' property ({$ma_response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('ma_response', $ma_response);
    }

    /**
     * ma_result ˲Ϸ̤ȤƽϤʻֹ򥻥åȤ
     *
     * @access public
     * @param string ma_result ˲Ϸ̤ȤƽϤʻֹ
     */
    function setMa_filter($ma_filter)
    {
        foreach (array_map('trim', explode('|', $ma_filter)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '10':
            case '11':
            case '12':
            case '13':
                break;
            default:
                trigger_error("[SyL error] Invalid `ma_filter' property ({$ma_filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('ma_filter', $ma_filter);
    }

    /**
     * uniq_result  word ֤Ǿ򥻥åȤ
     *
     * @access public
     * @param string uniq_result  word ֤Ǿ
     */
    function setUniq_response($uniq_response)
    {
        foreach (array_map('trim', explode(',', $uniq_response)) as $tmp) {
            switch ($tmp) {
            case 'surface':
            case 'reading':
            case 'pos':
            case 'baseform':
            case 'feature':
                break;
            default:
                trigger_error("[SyL error] Invalid `uniq_response' property ({$uniq_response}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('uniq_response', $uniq_response);
    }

    /**
     * uniq_result ˲Ϸ̤ȤƽϤʻֹ򥻥åȤ
     *
     * @access public
     * @param string uniq_result ˲Ϸ̤ȤƽϤʻֹ
     */
    function setUniq_filter($uniq_filter)
    {
        foreach (array_map('trim', explode('|', $uniq_filter)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case '10':
            case '11':
            case '12':
            case '13':
                break;
            default:
                trigger_error("[SyL error] Invalid `uniq_filter' property ({$uniq_filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('uniq_filter', $uniq_filter);
    }

    /**
     * ܷƱ򥻥åȤ
     *
     * @access public
     * @param bool ܷƱ
     */
    function setUniq_by_baseform($uniq_by_baseform)
    {
        $uniq_by_baseform = ($uniq_by_baseform) ? 'true' : 'false';
        parent::set('uniq_by_baseform', $uniq_by_baseform);
    }
}

?>
