<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriterAtom1_0.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Atom 1.0饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriterAtom1_0.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssWriterAtom1_0 extends SyL_XmlRssWriter
{
    /**
     * ͥǤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function setChannel($name, $value, $attributes=array())
    {
        // ݲ̾Ѵ
        switch ($name) {
        case 'copyright':
            $name = 'rights';
            break;
        case 'language':
            $name = 'dc:language';
            break;
        case 'date':
            $name  = 'updated';
        case 'updated':
            $value = $this->convertDateTime($value);
            break;
        }
        parent::setChannel($name, $value, $attributes);
    }

    /**
     * ܤ򥻥åȤ
     * 
     * @access public
     * @param string ̾
     * @param string 
     * @param array °
     */
    function addItem($values, $attributes=array())
    {
        // ݲ̾Ѵ
        foreach (array_keys($values) as $name) {
            switch ($name) {
            case 'description':
                $values['content'] = $values[$name];
                unset($values[$name]);
                break;
            case 'date':
                $values['published'] = $this->convertDateTime($values[$name]);
                unset($values[$name]);
                break;
            case 'published':
                $values['published'] = $this->convertDateTime($values[$name]);
                break;
            case 'updated':
                $values['updated'] = $this->convertDateTime($values[$name]);
                break;
            case 'copyright':
                $values['rights'] = $values[$name];
                unset($values[$name]);
                break;
            }
        }
        parent::addItem($values, $attributes);
    }

    /**
     * RSS XML
     * 
     * @access public
     */
    function createXml()
    {
        $this->addStartElement('feed',
          array(
            'xmlns'    => 'http://www.w3.org/2005/Atom',
            'xmlns:dc' => 'http://purl.org/dc/elements/1.1/'
          )
        );

        // ե
        foreach ($this->channel as $i => $values) {
            $this->createRecursiveElements($values[0], $values[1], (isset($this->channel_attr[$i]) ? $this->channel_attr[$i] : array()));
        }

        // ȥ꡼
        foreach ($this->items as $item) {
            $this->addStartElement('entry');
            foreach ($item as $name => $value) {
                $this->createRecursiveElements($name, $value);
            }
            $this->addEndElement();
        }

        $this->addEndElement();
    }

    /**
     * եޥåȤѴ
     *
     * 2007/03/12 00:00:00 -> 2007-03-12T00:00:00+0900
     *
     * @access public
     * @param string Ѵ
     * @return string Ѵ
     */
    function convertDateTime($datetime)
    {
        if (preg_match('/^([0-9]{4})[\-|\/]?([0-1][0-9])[\-|\/]?([0-3][0-9])[ ]*([0-2][0-9]:?[0-5][0-9]:?[0-5][0-9])?$/', trim($datetime))) {
            $timestamp = @strtotime($datetime);
            if ($timestamp) {
                $datetime = date('Y-m-d\TH:i:s+0900', $timestamp);
            }
        }
        return $datetime;
    }
}

?>
