<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.9 2008/09/23 09:06:16 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹
 */
SyL_Loader::lib('DB');
/**
 * ե饹
 */
SyL_Loader::lib('File');

/**
 * ADMѥեDAOѥơ֥륯饹륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.9 2008/09/23 09:06:16 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Index extends AppAction
{
    /**
     * ơ֥륪֥Ⱥǥ쥯ȥ
     *
     * @access private
     * @var string
     */
    var $table_dir = 'Adm.Tables.';
    /**
     * ե४֥Ⱥǥ쥯ȥ
     *
     * @access private
     * @var string
     */
    var $form_dir = 'Adm.Forms.';

    /**
     * ᥤ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();
        // С󥳥ޥ
        if ($data->is('h') || $data->is('help')) {
            $this->displayHelp($cmd, $data->get(0));
            return;
        // إץޥ
        } else if ($data->is('v') || $data->is('version')) {
            $this->displayVersion($cmd, $data->get(0));
            return;
        }

        $project_dir = $data->geta('d', 0);
        $app_name    = $data->geta('w', 0);
        $action_name = $data->geta('a', 0);
        $controller_dir = dirname($data->geta('c', 0));
        $tablename   = $data->geta('t', 0);
        $smarty_flag = $data->is('s');

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        if (!$project_dir) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }
        if (!is_dir($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $app_dir = '';
        if (!$app_name) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        }
        $app_dir = "{$project_dir}/apps/{$app_name}"; 
        if (!is_dir($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$app_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ơ֥̾å
        // -------------------------------------------------
        if (!$tablename) {
            trigger_error("[SyL error] Table name (-t) not found", E_USER_ERROR);
            exit;
        }

        $mkdirs = array();

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cmd->stdout("  project application directory checking...");

        $action_dir   = '';
        $template_dir = '';
        $action_names = array();
        if ($action_name) {
            $action_dir   = "{$app_dir}/actions";
            $template_dir = "{$app_dir}/templates";

            if (substr($action_name, 0, 1) == '/') {
                $action_name = substr($action_name, 1);
            }
            $action_names = array_map('ucfirst', explode('/', $action_name));
            $action_name = implode('/', $action_names);
            if (!is_dir("{$action_dir}/{$action_name}")) {
                if ($cmd->getInput('', "Action directory not found. create directory ? ({$action_dir}/{$action_name}) [Y/n]:") != 'Y') {
                    return;
                }
            }
            if (!is_dir("{$template_dir}/{$action_name}")) {
                if ($cmd->getInput('', "Template directory not found. create directory ? ({$template_dir}/{$action_name}) [Y/n]:") != 'Y') {
                    return;
                }
            }
            foreach ($action_names as $tmp) {
                if ($tmp != '') {
                    $action_dir .= "/{$tmp}";
                    if (file_exists($action_dir)) {
                        if (!is_dir($action_dir)) {
                            trigger_error("[SyL error] Invalid action directory check. already file exist ({$action_dir})", E_USER_ERROR);
                        }
                    } else {
                        $mkdirs[] = $action_dir;
                    }
                    $template_dir .= "/{$tmp}";
                    if (file_exists($template_dir)) {
                        if (!is_dir($template_dir)) {
                            trigger_error("[SyL error] Invalid template directory check. already file exist ({$template_dir})", E_USER_ERROR);
                        }
                    } else {
                        $mkdirs[] = $template_dir;
                    }
                }
            }
        }

        // -------------------------------------------------
        // ơ֥ǥ쥯ȥå
        // -------------------------------------------------
        $cmd->stdout("  project lib table directory checking...");

        $table_file  = $project_dir . '/lib';
        $table_class = $this->table_dir . ucfirst($tablename);
        $table_files = explode('/', substr(SyL_Loader::convertPath($table_class), 1));
        $cnt = count($table_files);
        $exist = true;
        for ($i=0; $i<$cnt; $i++) {
            $table_file .= '/' . $table_files[$i];
            if ($i == $cnt - 1) {
                if (file_exists($table_file)) {
                    if ($cmd->getInput('', "Already table file exist. overwrite file ? ({$table_file}) [Y/n]:") != 'Y') {
                        return;
                    }
                    if (!is_writable($table_file)) {
                        trigger_error("[SyL error] Invalid file check. Permission Denied ? ({$table_file})", E_USER_ERROR);
                    }
                }
            } else {
                if (file_exists($table_file)) {
                    if (!is_dir($table_file)) {
                        trigger_error("[SyL error] Invalid directory check. already file exist ({$table_file})", E_USER_ERROR);
                    }
                } else {
                    if ($exist && !is_writable(dirname($table_file))) {
                        trigger_error("[SyL error] Invalid directory check. create permission denied ? ({$table_file})", E_USER_ERROR);
                    }
                    $exist    = false;
                    $mkdirs[] = $table_file;
                }
            }
        }

        // -------------------------------------------------
        // եǥ쥯ȥå
        // -------------------------------------------------
        $cmd->stdout("  project lib form directory checking...");

        $form_file  = $project_dir . '/lib';
        $form_class = $this->form_dir . ucfirst($tablename);
        $form_files = explode('/', substr(SyL_Loader::convertPath($form_class), 1));
        $cnt   = count($form_files);
        $exist = true;
        for ($i=0; $i<$cnt; $i++) {
            $form_file .= '/' . $form_files[$i];
            if ($i == $cnt - 1) {
                if (file_exists($form_file)) {
                    if ($cmd->getInput('', "Already form file exist. overwrite file ? ({$form_file}) [Y/n]:") != 'Y') {
                        return;
                    }
                    if (!is_writable($form_file)) {
                        trigger_error("[SyL error] Unable overwrite. Permission Denied ? ({$form_file})", E_USER_ERROR);
                    }
                }
            } else {
                if (file_exists($form_file)) {
                    if (!is_dir($form_file)) {
                        trigger_error("[SyL error] Unable create directory. Already file exist ({$form_file})", E_USER_ERROR);
                    }
                } else {
                    if ($exist && !is_writable(dirname($form_file))) {
                        trigger_error("[SyL error] Invalid directory check. create permission denied ? ({$form_file})", E_USER_ERROR);
                    }
                    $exist    = false;
                    $mkdirs[] = $form_file;
                }
            }
        }

        // -------------------------------------------------
        // ƥġʥȥ˥ǥ쥯ȥå
        // -------------------------------------------------
        $image_dir = '';
        $css_dir   = '';
        if ($controller_dir) {
            $cmd->stdout("  images or css directory checking...");

            $image_dir = "{$controller_dir}/images";
            if (file_exists($image_dir)) {
                if (!is_dir($image_dir)) {
                    trigger_error("[SyL error] Unable create `images' directory. Already file exist ({$image_dir})", E_USER_ERROR);
                }
                if ($cmd->getInput('', "Already `images' directory exist. overwrite directory ? ({$image_dir}) [Y/n]:") != 'Y') {
                    return;
                }
                if (!is_writable($image_dir)) {
                    trigger_error("[SyL error] Invalid `images' directory check. create permission denied ? ({$image_dir})", E_USER_ERROR);
                }
            } else {
                if (!is_writable(dirname($image_dir))) {
                    trigger_error("[SyL error] Invalid `images' directory check. create permission denied ? ({$image_dir})", E_USER_ERROR);
                }
                $mkdirs[] = $image_dir;
            }

            $css_dir   = "{$controller_dir}/css";
            if (file_exists($css_dir)) {
                if (!is_dir($css_dir)) {
                    trigger_error("[SyL error] Unable create `css' directory. Already file exist ({$css_dir})", E_USER_ERROR);
                }
                if ($cmd->getInput('', "Already `css' directory exist. overwrite directory ? ({$css_dir}) [Y/n]:") != 'Y') {
                    return;
                }
                if (!is_writable($css_dir)) {
                    trigger_error("[SyL error] Invalid `css' directory check. create permission denied ? ({$css_dir})", E_USER_ERROR);
                }
            } else {
                if (!is_writable(dirname($css_dir))) {
                    trigger_error("[SyL error] Invalid `css' directory check. create permission denied ? ({$css_dir})", E_USER_ERROR);
                }
                $mkdirs[] = $css_dir;
            }
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        $project_config_file = $project_dir . '/config/defines.xml';
        $app_config_file     = $app_dir . '/config/defines.xml';

        if (!is_file($project_config_file)) {
            trigger_error("[SyL error] `defines.xml' not found in project directory({$project_config_file})", E_USER_ERROR);
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        $cmd->stdout("  project config getting...");

        $config =& SyL_Config::factory('defines');
        $config->setConfigFiles(array($app_config_file, $project_config_file));
        $config->parseXml(false);
        $values = $config->getConfig();

        if (!isset($values['SYL_DB_DSN']) || !$values['SYL_DB_DSN']) {
            trigger_error("[SyL error] `SYL_DB_DSN' constant not defined in config file({$project_config_file} or {$app_config_file})", E_USER_ERROR);
        }

        $connection_string = $values['SYL_DB_DSN'];

        // -------------------------------------------------
        // ơ֥륹޼
        // -------------------------------------------------
        $cmd->stdout("  table schema scaning...");

        // ơ֥륹޼
        $conn =& SyL_DB::getConnection($connection_string);
        $schema =& $conn->getSchema();
        $table_columns  = $schema->getColumns($tablename);
        $table_primary  = $schema->getPrimary($tablename);
        $table_uniques  = $schema->getUniques($tablename);
        $table_foreigns = $schema->getForeigns($tablename);
        $conn->closeConnection();

        if (count($table_columns) == 0) {
            trigger_error("[SyL error] Table schema not found ({$tablename})", E_USER_ERROR);
        }

        // -------------------------------------------------
        // ѿ˥å
        // -------------------------------------------------
        $cmd->stdout("  valiables setting...");

        $tables   = array();
        $columns  = array();
        $elements = array();

        $maintenance_table = 'a';
        $tables[$maintenance_table] = $table_class;

        $i = 1;
        foreach ($table_columns as $name => $column) {
            // ʸ
            $name = strtoupper($name);
            // ơ֥
            $columns[$name] = array(
              'type'     => $column['type'],
              'validate' => $this->getValidateDefinition($column)
            );
            // ե
            $elements[$name] = array(
              'alias'       => $maintenance_table,
              'type'        => 'text',
              'name'        => $name,
              'attributes'  => array('size' => '30'),
              'validate'    => array(),
              'sort_list'   => $i,
              'sort_detail' => $i
            );
            $i++;
        }

        // ʸ
        $table_primary = array_map('strtoupper', $table_primary);
        for ($i=0; $i<count($table_uniques); $i++) {
            $table_uniques[$i] = array_map('strtoupper', $table_uniques[$i]);
        }
        foreach (array_keys($table_foreigns) as $key) {
            $table_foreigns[$key] = array_change_key_case($table_foreigns[$key], CASE_UPPER);
            $table_foreigns[$key] = array_map('strtoupper', $table_foreigns[$key]);
        }

        // ȥ
        $sorts = array();
        foreach ($table_primary as $name) {
            $sorts[] = "{$maintenance_table}.{$name}.ASC";
        }

        // ơ֥륯饹Ѵ
        $table_search  = array();
        $table_replace = array();
        // ץ̾
        $table_search[]  = '{PROJECT_NAME}';
        $table_replace[] = basename($project_dir);
        // 饹̾
        $table_search[]  = '{TABLE_CLASS_NAME}';
        $table_replace[] = SyL_Loader::convertClass($table_class);
        // ơ֥̾
        $table_search[]  = '{TABLE_NAME}';
        $table_replace[] = $tablename;
        // 祭
        $table_search[]  = '{TABLE_PRIMARY}';
        $table_replace[] = var_export($table_primary, true);
        // ե
        $table_search[]  = '{TABLE_UNIQUES}';
        $table_replace[] = var_export($table_uniques, true);
        // 
        $table_search[]  = '{TABLE_FOREIGNS}';
        $table_replace[] = var_export($table_foreigns, true);
        // 
        $table_search[]  = '{TABLE_COLUMNS}';
        $table_replace[] = var_export($columns, true);

        // ե९饹Ѵ
        $form_search  = array();
        $form_replace = array();
        // ץ̾
        $form_search[]  = '{PROJECT_NAME}';
        $form_replace[] = basename($project_dir);
        // 饹̾
        $form_search[]  = '{FORM_CLASS_NAME}';
        $form_replace[] = SyL_Loader::convertClass($form_class);
        // ơ֥륯饹̾
        $form_search[]  = '{FORM_TABLES}';
        $form_replace[] = var_export($tables, true);
        // ᥤƥʥ󥹥ơ֥
        $form_search[]  = '{FORM_MAINTENANCE_TABLE}';
        $form_replace[] = $maintenance_table;
        // ǥեȥ
        $form_search[]  = '{FORM_SORTS}';
        $form_replace[] = var_export($sorts, true);
        // ե
        $form_search[]  = '{FORM_ELEMENTS}';
        $form_replace[] = var_export($elements, true);
        // ơ֥̾
        $form_search[]  = '{FORM_TITLE}';
        $form_replace[] = $tablename . '';

        // ե饹Ѵ
        $form_opp_search  = array();
        $form_opp_replace = array();
        if ($action_name) {
            // ץ̾
            $form_opp_search[]  = '{PROJECT_NAME}';
            $form_opp_replace[] = basename($project_dir);
            // ǥ쥯ȥ
            $form_opp_search[]  = '{ACTION_DIR}';
            $form_opp_replace[] = (count($action_names) > 0) ? implode('_', $action_names) . '_' : '';
            // ƥץ졼ȥǥ쥯ȥ
            $form_opp_search[]  = '{TEMPLATE_DIR}';
            $form_opp_replace[] = (count($action_names) > 0) ? implode('/', $action_names) . '/' : '';
            // ե९饹̾
            $form_opp_search[]  = '{FORM_CLASS_NAME}';
            $form_opp_replace[] = SyL_Loader::convertClass($form_class);
            // ե९饹ѥ
            $form_opp_search[]  = '{FORM_CLASS_PATH}';
            $form_opp_replace[] = $form_class;
        }

        // -------------------------------------------------
        // ǥ쥯ȥ
        // -------------------------------------------------
        $cmd->stdout("  create directories...");

        foreach ($mkdirs as $dir) {
            if (!file_exists($dir)) {
                $cmd->stdout("  create directory {$dir}");
                mkdir($dir);
            }
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        $cmd->stdout("  create files...");

        // ƥץ졼ȥե
        $template_table_file     = SYL_PROJECT_DIR . '/var/templates/Table.php';
        $template_form_file      = SYL_PROJECT_DIR . '/var/templates/Form.php';

        // ơ֥ե
        $cmd->stdout("  table template file {$template_table_file}");
        $cmd->stdout("    -> generating table file {$table_file}");

        SyL_File::writeContents($table_file, str_replace($table_search, $table_replace, file_get_contents($template_table_file)));

        // եե
        $cmd->stdout("  form template file {$template_form_file}");
        $cmd->stdout("    -> generating form file {$form_file}");

        SyL_File::writeContents($form_file, str_replace($form_search, $form_replace, file_get_contents($template_form_file)));

        if ($action_name) {
            // ե
            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Index.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Lst.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/New.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Upd.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Del.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Fin.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Vew.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            // ƥץ졼ȥե
            $dir = ($smarty_flag) ? 'smarty' : 'default';

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Lst.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/New.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Upd.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Fin.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Vew.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));
        }

        // ե륳ԡ
        if ($image_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/images';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$image_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$image_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }

        // CSSե륳ԡ
        if ($css_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/css';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$css_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$css_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }

        // -------------------------------------------------
        // ɽ
        // -------------------------------------------------

        $cmd->stdout("");
        $cmd->stdout("--- Result ---");
        $cmd->stdout("  [project directory] {$project_dir}");
        if ($action_name) {
            $cmd->stdout("  [action directory] {$action_dir}");
            $cmd->stdout("  [template directory] {$template_dir}");
        }
        $cmd->stdout("  [table name] {$tablename}");
        $cmd->stdout("  [form class] {$form_file}");
        $cmd->stdout("  [table class] {$table_file}");
        if ($image_dir) {
            $cmd->stdout("  [images directory] {$image_dir}");
        }
        if ($css_dir) {
            $cmd->stdout("  [css directory] {$css_dir}");
        }

        if ($action_name) {
            $action_name = '/' . strtolower($action_name);
            $cmd->stdout("--- URL ---");
            $cmd->stdout("  http://(hostname)/(controller_file){$action_name}/");
        }
    }

    /**
     * ෿Хǡ
     *
     * @access private
     * @param array °
     * @param array Хǡ
     */
    function getValidateDefinition($column)
    {
        $validate = array();
        // ɬܥå
        if ($column['not_null']) {
            $validate['require'] = array('message' => '{name}ɬܤǤ');
        }
        switch ($column['type']) {
        // 
        case 'I':
            $validate['numeric'] = array(
              'message'    => '{name}ϿͤϤƤ',
              'parameters' => array(
                'dot' => false,
                'min' => $column['min'],
                'max' => $column['max'],
                'min_error_message' =>  '{name}{min}ʾϤƤ',
                'max_error_message' =>  '{name}{max}ʲϤƤ'
              )
            );
            break;

        // ư
        case 'F':
            $validate['numeric'] = array(
              'message'    => '{name}ϿͤϤƤ',
              'parameters' => array(
                'dot' => true
              )
            );
            break;

        // ͷ
        case 'N':
            $validate['numeric'] = array(
              'message'    => '{name}ϿͤϤƤ',
              'parameters' => array(
                'dot' => true,
                'min' => $column['min'],
                'max' => $column['max'],
                'min_error_message' =>  '{name}{min}ʾϤƤ',
                'max_error_message' =>  '{name}{max}ʲϤƤ'
              )
            );
            break;

        // շ
        case 'D':
        case 'DT':
            $validate['date'] = array(
              'message' => '{name}դϤƤ'
            );
            break;

        // ַ
        case 'T':
            $validate['regex'] = array(
              'message' => '{name}ޤ',
              'parameters' => array(
                'format' => '/^([0-1][0-9]|2[0-3]):?([0-5][0-9]):?([0-5][0-9])$/'
              )
            );
            break;

        // ʸ
        case 'S':
            $validate['length'] = array(
              'message'    => '{name}{max}ʸʥХȡ˰ϤƤ',
              'parameters' => array(
                'max' => $column['max']
              )
            );
            break;
        }
        return $validate;
    }

    /**
     * إפɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayHelp(&$cmd, $file)
    {
        $help = <<<EOF
Usage:
  php {$file} -d <dir> -w <name> [-a <dir>] [-c <file>] -t <table> [-s]
  php {$file} [option]

Options:
  -d <dir>   project directory
  -w <name>  application name
  -a <dir>   action directory for Adm Application (default: null)
  -c <file>  controller file (default: null)
  -t <table> database table name
  -s         generate smarty template (default: PHP template)
  -h         show this help, then exit
  -v         output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayVersion(&$cmd, $file)
    {
        $syl_version = SYL_VERSION;
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$syl_version} (PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (C) 2006-2008 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayDefault(&$cmd, $file)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
