<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Cache.php,v 1.19 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * LbVNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Cache.php,v 1.19 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Cache
{
    /**
     * LbṼL[
     *
     * @access protected
     * @var string
     */
    var $key = '';
    /**
     * LbṼL[MD5
     *
     * @access protected
     * @var string
     */
    var $key_md5 = '';
    /**
     * LbV̐ړ
     *
     * @access private
     * @var string
     */
    var $prefix = 'syl_cache.';
    /**
     * LbV̗L
     * Pʂ͕b[s]
     *
     * @access protected
     * @var int
     */
    var $life_time = 86400; // 1day
    /**
     * XVԂ̍ŏl
     * LbVÂȂĂȂ̊mFp
     *
     * @access protected
     * @var int
     */
    var $min_mtime = 0; // 0:
    /**
     * XVԂ̍ől
     *
     * @access protected
     * @var int
     */
    var $max_mtime = 0; // 0:
    /**
     * LbVt@C̊mFCRCt邩
     *
     * @access private
     * @var bool
     */
    var $crc = true;
    /**
     * LbVt@CVA邩
     *
     * @access private
     * @var bool
     */
    var $serial = true;

    /**
     * RXgN^
     *
     * @access public
     */
    function SyL_Cache()
    {
    }

    /**
     * LbVIuWFNg擾
     *
     * @static
     * @access public
     * @param string LbṼL[
     * @param string LbV^Cv
     */
    function &factory($type='file')
    {
        $classname = 'SyL_Cache' . ucfirst($type);
        include_once dirname(__FILE__) . "/Cache/{$classname}.php";
        $obj = new $classname();
        return $obj;
    }

    /**
     * LbVt@C̐ړZbg
     *
     * @access public
     * @param string LbVt@C̐ړ
     */
    function setPrefix($prefix)
    {
        $this->prefix = $prefix;
    }

    /**
     * LbṼL[Zbg
     *
     * @access public
     * @param string LbVL[
     */
    function setKey($key)
    {
        $this->key     = $key;
        $this->key_md5 = md5($key);
    }

    /**
     * LbṼL[擾
     *
     * @access public
     * @param bool MD5tL[tO
     * @return string LbVL[
     */
    function getKey($md5=true)
    {
        return $this->prefix . ($md5 ? $this->key_md5 : '');
    }

    /**
     * LbVLԂZbg
     *
     * @access public
     * @param int LbVLԁib[s]j
     */
    function setLifeTime($life_time)
    {
        $this->life_time = $life_time;
    }

    /**
     * LbVLԂiiɁj
     *
     * @access public
     */
    function persistentLifeTime()
    {
        $this->setMinModifyTime(0);
        $this->setMaxModifyTime(0);
        $this->setLifeTime(0);
    }

    /**
     * XVԂ̍ŏlZbg
     *
     * @access public
     * @param int XVԂ̍ŏlib[s]j
     */
    function setMinModifyTime($min_mtime)
    {
        $this->min_mtime = $min_mtime;
    }

    /**
     * XVԂ̍őlZbg
     *
     * @access public
     * @param int XVԂ̍őlib[s]j
     */
    function setMaxModifyTime($max_mtime)
    {
        $this->max_mtime = $max_mtime;
    }

    /**
     * LbV̍XVԂXV
     *
     * @access public
     * @param int XV(UNIX Time)
     * @return bool true: XVOKAfalse: XVG[
     */
    function setModifyTime($mtime=0)
    {
    }

    /**
     * Kx[WRNVw肵mŋN
     *
     * @access public
     * @param int Nmi0 - 100j
     */
    function gc($per)
    {
        if (is_numeric($per) && (($per >= 0) && ($per <= 100))) {
            if (($per > 0) && ($per >= mt_rand(1, 100))) {
                register_shutdown_function(array(&$this, 'clean'));
            }
        } else {
            trigger_error("[SyL error] Invalid gc method parameter ({$per})", E_USER_ERROR);
        }
    }

    /**
     * LbV̍XVԂ擾
     *
     * @access public
     * @return int XV(UNIX Time)
     */
    function getModifyTime()
    {
    }

    /**
     * LbVǂݍ
     *
     * @access public
     * @param bool LbVLԂXV
     * @param int ŒXViUNIX timej
     * @return mixed LbVf[^
     */
    function read($modify_time_update=false)
    {
    }

    /**
     * LbVۑ
     *
     * @access public
     * @param mixed LbVf[^
     * @return bool true: ۑAfalse: ۑG[
     */
    function write($data)
    {
    }

    /**
     * LbV폜
     * 
     * @access public
     * @return bool true: 폜Afalse: 폜G[
     */
    function delete()
    {
    }

    /**
     * LbV̊؂LbV폜
     *
     * @access public
     */
    function clean()
    {
    }

    /**
     * LbVSč폜
     *
     * @access public
     */
    function cleanAll()
    {
    }

    /**
     * CRCǉtOZbg
     * 
     * @access public
     * @param bool CRCǉtO
     */
    function setCrc($flag)
    {
        $this->crc = (bool)$flag;
    }

    /**
     * CRCL
     * 
     * @access public
     * @return bool CRCL
     */
    function isCrc()
    {
        return $this->crc;
    }

    /**
     * CRCǉf[^擾
     * 
     * @access public
     * @param string f[^
     * @return string nbVl
     */
    function getCrc($data)
    {
        return sprintf('%+032d', crc32($data));
    }

    /**
     * VAtOZbg
     * 
     * @access public
     * @param bool VAtO
     */
    function setSerialize($flag)
    {
        $this->serial = (bool)$flag;
    }

    /**
     * VA
     * 
     * @access public
     * @return bool VA
     */
    function isSerialize()
    {
        return $this->serial;
    }
}

?>
