<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jp.php,v 1.2 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥꥯȥ饹ʳŷ
 */
require_once dirname(__FILE__) . '/Rakuten_co_jp/SyL_WebServiceRakuten_co_jpRequest.php';
/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ
 */
require_once dirname(__FILE__) . '/Rakuten_co_jp/SyL_WebServiceRakuten_co_jpResponse.php';

/**
 * WEBӥ饹ʳŷѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jp.php,v 1.2 2008/07/10 15:17:43 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceRakuten_co_jp extends SyL_WebService
{
    // -----------------------------------------------------
    // ŷԾAPI
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥ȤʳŷʸAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷʸAPIѡ
     */
    function &createItemSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceMarketItemSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/ItemSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('ItemSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʳŷ븡APIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷ븡APIѡ
     */
    function &createGenreSearchRequest($version='2007-04-11')
    {
        $class_name = 'SyL_WebServiceMarketGenreSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/GenreSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('GenreSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʳŷʥɸAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷʥɸAPIѡ
     */
    function &createItemCodeSearchRequest($version='2007-04-11')
    {
        $class_name = 'SyL_WebServiceMarketItemCodeSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/ItemCodeSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('ItemCodeSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʳŷAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷAPIѡ
     */
    function &createCatalogSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceMarketCatalogSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/CatalogSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('CatalogSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // ŷ֥åAPI
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥ȤʳŷҸAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷҸAPIѡ
     */
    function &createBookSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceBooksBookSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Books/BookSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('BookSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʳŷCDAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷCDAPIѡ
     */
    function &createCDSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceBooksCDSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Books/CDSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('CDSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʳŷDVDAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷDVDAPIѡ
     */
    function &createDVDSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceBooksDVDSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Books/DVDSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('DVDSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // ŷAPI
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥ȤʳŷʸAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷʸAPIѡ
     */
    function &createAuctionItemSearchRequest($version='2007-12-13')
    {
        $class_name = 'SyL_WebServiceAuctionAuctionItemSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Auction/AuctionItemSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('AuctionItemSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʳŷʥɸAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷʥɸAPIѡ
     */
    function &createAuctionItemCodeSearchRequest($version='2007-12-13')
    {
        $class_name = 'SyL_WebServiceAuctionAuctionItemCodeSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Auction/AuctionItemCodeSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('AuctionItemCodeSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // ŷȥ٥API
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥Ȥʳŷȥ٥߸APIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷȥ٥߸APIѡ
     */
    function &createSimpleHotelSearchRequest($version='2007-11-21')
    {
        $class_name = 'SyL_WebServiceTravelSimpleHotelSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/SimpleHotelSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('SimpleHotelSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʳŷȥ٥߾APIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷȥ٥߾APIѡ
     */
    function &createHotelDetailSearchRequest($version='2007-11-21')
    {
        $class_name = 'SyL_WebServiceTravelHotelDetailSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/HotelDetailSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('HotelDetailSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʳŷȥ٥APIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷȥ٥APIѡ
     */
    function &createVacantHotelSearchRequest($version='2008-02-14')
    {
        $class_name = 'SyL_WebServiceTravelVacantHotelSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/VacantHotelSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('VacantHotelSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʳŷȥ٥϶襳APIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷȥ٥϶襳APIѡ
     */
    function &createGetAreaClassRequest($version='2008-02-14')
    {
        $class_name = 'SyL_WebServiceTravelGetAreaClassRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/GetAreaClass/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('GetAreaClass');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBӥꥯȥ֥Ȥʳŷȥ٥륭ɸAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷȥ٥륭ɸAPIѡ
     */
    function &createKeywordHotelSearchRequest($version='2007-09-19')
    {
        $class_name = 'SyL_WebServiceTravelKeywordHotelSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/KeywordHotelSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('KeywordHotelSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // ¾API
    // -----------------------------------------------------

    /**
     * WEBӥꥯȥ֥ȤʳŷʥߥåAPIѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷʥߥåAPIѡ
     */
    function &createDynamicRequest()
    {
        $class_name = 'SyL_WebServiceAdDynamicRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Ad/Dynamic/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBӥꥯȥ֥ȤʳŷʥߥåAPIȥ٥ѡ
     * 
     * @access public
     * @param string С
     * @return object WEBӥꥯȥ֥ȡʳŷʥߥåAPIȥ٥ѡ
     */
    function &createDynamicTravelRequest()
    {
        $class_name = 'SyL_WebServiceAdDynamicTravelRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Ad/DynamicTravel/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }
}

?>
