<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroCategoryTreeResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - Yahoo!η:ƥĥ꡼ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * Yahoo!η:ƥĥ꡼
 *   http://developer.yahoo.co.jp/chiebukuro/categoryTree/V1/categoryTree.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroCategoryTreeResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceChiebukuroCategoryTreeResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡΥޥå꡼
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            break;

        // ƥ
        case '/ResultSet/Result/Category': $i++; break;
        // ƥID
        case '/ResultSet/Result/Category/Id': $this->results[$i]['Id'] = $text; break;
        // ƥ̾
        case '/ResultSet/Result/Category/Title': $this->results[$i]['Title'] = $text; break;
        // ɽƥID
        case '/ResultSet/Result/Category/IdPath': $this->results[$i]['IdPath'] = $text; break;
        // ɽƥ̾
        case '/ResultSet/Result/Category/Path': $this->results[$i]['Path'] = $text; break;

        // =============================
        // 顼
        // =============================
        // 顼Ƚ
        case '/ResultSet/Status/StatusCode': if($text == '-1'){$this->error = true;} break;
        // 顼å
        case '/ResultSet/Status/Error/Message': $this->error_message .= '[code: ' . $attribute['code'] . '] ' . $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ̥ǡ
     *
     * @access public
     * @return array ̥ǡ
     */
    function getResults()
    {
        return $this->results;
    }
}

?>
