<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceKadenProductSearchRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ʸѡ
 */
require_once 'SyL_WebServiceKadenProductSearchResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ʸѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ʸ
 *   http://developer.yahoo.co.jp/kaden/productsearch/v1/productsearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceKadenProductSearchRequest.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceKadenProductSearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'kaden.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/KadenWebService/V1/ProductSearch';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceKadenProductSearchResponse';

    /**
     * ꡼򥻥åȤ
     *
     * @access public
     * @param string ꡼
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * ̤Υڡֹ򥻥åȤ
     *
     * @access public
     * @param int ̤Υڡֹ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page)) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ƥID򥻥åȤ
     *
     * @access public
     * @param string ƥID
     */
    function setCategory($category)
    {
        parent::set('category', $category);
    }

    /**
     * ʲʤϰϻβͤ򥻥åȤ
     *
     * @access public
     * @param int ʲʤϰϻβ
     */
    function setMinprice($minprice)
    {
        if (preg_match('/^\d+$/', $minprice)) {
            parent::set('minprice', $minprice);
        } else {
            trigger_error("[SyL error] Invalid `minprice' property ({$minprice}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʲʤϰϻξͤ򥻥åȤ
     *
     * @access public
     * @param int ʲʤϰϻξ
     */
    function setMaxprice($maxprice)
    {
        if (preg_match('/^\d+$/', $maxprice)) {
            parent::set('maxprice', $maxprice);
        } else {
            trigger_error("[SyL error] Invalid `maxprice' property ({$maxprice}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʥꥹȤΥȹܤ򥻥åȤ
     *
     * @access public
     * @param string ʥꥹȤΥȹ
     */
    function setSort($sort)
    {
        switch ($sort) {
        case 'access': // 
        case 'price': // ʽ
        case 'date': // ȯ
        case 'review ': // 
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ȥν򥻥åȤ
     *
     * @access public
     * @param string Ȥν
     */
    function setOrder($order)
    {
        switch ($order) {
        case 'a': // 
        case 'd': // ߽
            parent::set('order', $order);
            break;
        default:
            trigger_error("[SyL error] Invalid `order' property ({$order}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
