<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationLst.php,v 1.11 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̥쥤䡼ǡ饹 - 
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationLst.php,v 1.11 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmOperationLst extends SyL_AdmOperation
{
    /**
     * ץ̾Ѵθ
     *
     * @access private
     * @var array
     */
    var $option_values = array();

    /**
     * ɽǡ
     *
     * @access public
     * @param string ȹ
     * @param int ڡ
     * @return array ɽǡ
     */
    function getList($sort=null, $page=1, $limit='')
    {
        // ȹ
        $sorts = ($sort) ? explode(',', $sort) : $this->form->getStructConfig('default_sort');
        // 1ڡɽ
        if ($limit === '') {
            $limit = $this->form->getStructConfig('page_records');
        }

        // ץDBƤ
        $data_sources = $this->form->getDataSources();

        $conn =& $this->dao->getConnection();

        // ơ֥륪֥Ⱥ롼
        $tables = array();
        $option_tmp_column = 'ADM_OPTION_COLUMN';
        $option_tmp_index  = 1;
        foreach (array_keys($this->tables) as $alias) {
            $table =& $this->tables[$alias];
            // ץDBƤ硢ɲäǥå
            foreach ($data_sources as $name => $data_source) {
                if ($alias == $data_source['alias']) {
                    if ($name != $data_source['value']) {
                        $tmp_option_column = $option_tmp_column . $option_tmp_index++;
                        $table->set($data_source['value'], $tmp_option_column);
                        $data_sources[$name]['value'] = $tmp_option_column;
                    }
                    $tmp_option_column = $option_tmp_column . $option_tmp_index++;
                    $table->set($data_source['name'], $tmp_option_column);
                    $data_sources[$name]['name'] = $tmp_option_column;
                }
            }

            // 
            $conditions = $this->dao->createCondition();
            foreach ($this->form->getValues($alias) as $column => $value) {
                if (is_array($value)) {
                    $in = array();
                    foreach ($value as $name => $value1) {
                        // ̾select, checkbox
                        if (is_int($name)) {
                            if (($value1 !== null) && ($value1 !== '')) {
                                $in[] = $value1;
                            }
                        // 롼ԥ
                        } else {
/*
                            if (is_array($value1)) {
                                foreach ($value1 as $value2) {
                                    if (($value2 !== null) && ($value2 !== '')) {
                                        $in[] = $value2;
                                    }
                                }
                            } else {
                                if (($value1 !== null) && ($value1 !== '')) {
                                    $conditions->addLike($column, '%' . $conn->escapeLike($value1) . '%');
                                }
                            }
*/
                        }
                    }
                    if (count($in) > 0) {
                        $conditions->addIn($column, $in);
                    }
                } else {
                    if (($value !== null) && ($value !== '')) {
                        $conditions->addLike($column, '%' . $conn->escapeLike($value) . '%');
                    }
                }
            } 
            $table->setConditions($conditions);

            // Ⱦ
            $primarys = array();
            if ($alias == $this->form->getMaintenanceTable()) {
                $primarys = $this->getPrimary(true);
            }
            foreach ($sorts as $sort) {
                list($alias_tmp, $column_tmp) = explode('.', $sort, 3);
                if ($alias == $alias_tmp) {
                    $table->addSortLink($sort);
                    $key = array_search("{$alias_tmp}.{$column_tmp}", $primarys);
                    if ($key !== false) {
                        unset($primarys[$key]);
                    }
                }
            }
            foreach ($primarys as $primary) {
                $table->addSortLink("{$primary}.ASC");
            }

            $tables[$alias] =& $table;
        }

        // ڡ󥻥å
        $this->dao->setPage($page, $limit);
        // ɽǡ
        $results = $this->dao->select($tables, $this->relation);

        // ץɽ̾Ѵ
        $options = array();
        $display_limits = array();
        foreach (array_keys($this->dao->getSelectHeaders()) as $name) {
            $options[$name] = $this->form->getOption($name);
            $element_config = $this->form->getConfig($name);
            $display_limits[$name] = (isset($element_config['display_limit_list']) && is_numeric($element_config['display_limit_list']))
                                   ? $element_config['display_limit_list']
                                   : null;
        }

        $cnt = count($results);
        for ($i=0; $i<$cnt; $i++) {
            // ꥪץ̾Ѵ
            foreach ($results[$i] as $name => $value) {
                if ($display_limits[$name] !== null) {
                    if (mb_strlen($results[$i][$name]) > $display_limits[$name]) {
                        $results[$i][$name] = mb_substr($results[$i][$name], 0, $display_limits[$name], SYL_ENCODE_INTERNAL) . '...';
                    }
                }
                if ($options[$name] !== null) {
                    // ͤ
                    $this->option_values[$i][$name] = $results[$i][$name];
                    // ץ̾ѹ
                    $results[$i][$name] = isset($options[$name][$value]) ? $options[$name][$value] : '';
                }
            }
            // DBץ̾Ѵ
            foreach ($data_sources as $name => $data_source) {
                // ͤ
                $this->option_values[$i][$name] = $results[$i][$name];
                // ץ̾ѹ
                $results[$i][$name] = $results[$i][$data_source['name']];
            }
        }
        return $results;
    }

    /**
     * Ȥθͤ
     *
     * @access public
     * @return array 
     */
    function getSearchParameters()
    {
        $search_parameters = array();
        // ơ֥륪֥Ⱥ롼
        foreach (array_keys($this->tables) as $alias) {
            foreach ($this->form->getValues($alias) as $column => $value) {
                if (is_array($value)) {
                    foreach ($value as $column1 => $value1) {
                        // ̾select, checkbox
                        if (is_int($column1)) {
                            if (($value1 !== null) && ($value1 !== '')) {
                                $search_parameters[] = $column . '[]=' . urlencode($value1);
                            }
                        // 롼ԥ
                        } else {
/*
                            if (is_array($value1)) {
                                foreach ($value1 as $value2) {
                                    if (($value2 !== null) && ($value2 !== '')) {
                                        $search_parameters[] = $column1 . '[]=' . urlencode($value2);
                                    }
                                }
                            } else {
                                if (($value1 !== null) && ($value1 !== '')) {
                                    $search_parameters[] = $column1 . '=' . urlencode($value1);
                                }
                            }
*/
                        }
                    }
                } else {
                    if (($value != null) && ($value !== '')) {
                        $search_parameters[] = $column . '=' . urlencode($value);
                    }
                }
            }
        }
        return $search_parameters;
    }

    /**
     * ڡ֥Ȥ
     *
     * @access public
     * @return object ڡ֥
     */
    function &getPager()
    {
        return $this->dao->getPager();
    }

    /**
     * ڡϰ
     *
     * @access public
     * @param object ڡ֥
     * @param int ڡɽ
     * @return array ڡϰ
     */
    function getPageLinks(&$pager, $range=9)
    {
        list($start, $end) = $pager->getRange($range);
        $links = array();
        for ($i=$start; $i<=$end; $i++) {
            $links[] = $i;
        }
        return $links;
    }

    /**
     * إåɽܤ
     *
     * @access public
     * @return array إåɽ
     */
    function getSelectHeaders()
    {
        $headers     = array();
        $headers_tmp = $this->dao->getSelectHeaders();
        // ¤ӽɽ̾ѹ
        foreach ($this->form->getListColumns() as $name) {
            $headers[$name] = $headers_tmp[$name];
            $element_config = $this->form->getConfig($name);
            $headers[$name]['name'] = $element_config['name'];
        }
        return $headers;
    }

    /**
     * ȤΥȹܤ
     *
     * @access public
     * @return array ȤΥȹ
     */
    function getSortColumns()
    {
        return implode(',', $this->dao->getSortColumns());
    }

    /**
     * ǥեȸܥåɽȽ
     *
     * @access public
     * @return bool true: ɽfalse: ɽ
     */
    function isDefaultSearchView()
    {
        if ($this->isSch()) {
            return (bool)$this->form->getStructConfig('default_search_view');
        } else {
            return false;
        }
    }

    /**
     * ɽǡбץ饤ޥ꡼󥯤
     *
     * @access public
     * @param array ɽǡ
     * @return array ץ饤ޥ꡼
     */
    function getPrimaryLinkParameters(&$results)
    {
        $primary_link_parameters = array();
        $primaries = $this->getPrimary(false);
        foreach ($results as $i => $values) {
            $keys = array();
            foreach ($primaries as $name) {
                if (isset($this->option_values[$i][$name])) {
                    $keys[$name] = $this->option_values[$i][$name];
                } else {
                    $keys[$name] = $values[$name];
                }
            }
            $primary_link_parameters[$i] = $this->encodeKey($keys);
        }
        return $primary_link_parameters;
    }
}

?>
