<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.24 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥ᡼ե졼ͤ륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterParameter.php,v 1.24 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RouterParameter extends SyL_Router
{
    /**
     * ζڤʸ
     *
     * @access protected
     * @var string
     */
    var $action_delimiter = '.';
    /**
     * ᥽åɤζڤʸ
     *
     * @access protected
     * @var string
     */
    var $method_delimiter = ':';

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * @access public
     * @param object ǡ֥
     */
    function createActionInfo(&$data)
    {
        $this->setRouterInfo($data->geta(SYL_ACTION_KEY, 0));
    }

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * @access protected
     * @param string ̾
     */
    function setRouterInfo($action)
    {
        if ($action === null) {
            $this->action_method = '';
            $this->action_file = $this->action_file_default;
        } else {
            $actions_path = explode($this->action_delimiter, $action);
            $method   = explode($this->method_delimiter, $actions_path[count($actions_path)-1], 2);

            $this->action_method = (count($method) == 2) ? ucfirst($method[1]) : $this->action_method;
            array_pop($actions_path);
            $action_dir = implode('/', array_map('ucfirst', $actions_path));
            if ($action_dir) {
                $this->action_file = $action_dir . '/' . ucfirst($method[0]) . $this->exe_ext;
            } else {
                $this->action_file = ucfirst($method[0]) . $this->exe_ext;
            }
        }

        // ƥץ졼ȥե
        $this->setTemplateFile(substr($this->action_file, 0, intval('-' . strlen($this->exe_ext))) . SYL_ROUTER_URL_EXT);
        // ꥸʥ륢ե
        $this->action_file_org = $this->action_file;
    }
}

?>
