<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterPathinfo.php,v 1.24 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * PATH_INFOĶѿե졼ͤ륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RouterPathinfo.php,v 1.24 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RouterPathinfo extends SyL_Router
{
    /**
     * ζڤʸ
     *
     * @access private
     * @var string
     */
    var $action_delimiter = '.';

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * @access public
     * @param object ǡ֥
     */
    function createActionInfo(&$data)
    {
        // PATH_INFOĶѿ
        $pathinfo = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';

        if ($pathinfo == '') {
            $this->action_method = '';
            $this->action_file = $this->action_file_default;
        } else if (substr($pathinfo, -1) == '/') {
            $this->action_method = '';
            $this->action_file = implode('/', array_map('ucfirst', explode('/', $pathinfo))) . $this->action_file_default;
        } else {
            // ĥȽ
            if (SYL_ROUTER_URL_EXT && !preg_match('/^(.+)(' . preg_quote(SYL_ROUTER_URL_EXT) . ')$/', $pathinfo)) {
                SyL_Response::forwardFileNotFound();
            }
            $pathinfo_file  = basename($pathinfo);
            $pathinfo_dir   = dirname($pathinfo);
            $pathinfo_files = explode($this->action_delimiter, $pathinfo_file, 2);

            switch ($pathinfo_dir) {
            case '':
            case '\\':
            case '/':
                $pathinfo_dir = '';
                break;
            default:
                $pathinfo_dir = substr($pathinfo_dir, 1);
                $pathinfo_dir = implode('/', array_map('ucfirst', explode('/', $pathinfo_dir))) . '/';
                break;
            }
            if (count($pathinfo_files) == 2) {
                if (($this->action_delimiter == '.') && (SYL_ROUTER_URL_EXT == ('.' . $pathinfo_files[1]))) {
                    // ᥽åɤʤ
                    $this->action_method = '';
                    $this->action_file = $pathinfo_dir . ucfirst($pathinfo_files[0]) . $this->exe_ext;
                } else {
                    $this->action_method = ucfirst($pathinfo_files[0]);
                    if (preg_match('/^(.+)(' . preg_quote(SYL_ROUTER_URL_EXT) . '|' . preg_quote($this->exe_ext) . ')$/', $pathinfo_files[1], $matches)) {
                        // ᥽åɤ
                        $this->action_file = $pathinfo_dir . ucfirst($matches[1]) . $this->exe_ext;
                    } else {
                        // ᥽åɤ
                        $this->action_file = $pathinfo_dir . ucfirst($pathinfo_files[1]) . $this->exe_ext;
                    }
                }
            } else {
                // ᥽åɤʤ
                $this->action_method = '';
                if (preg_match('/^(.+)(' . preg_quote(SYL_ROUTER_URL_EXT) . '|' . preg_quote($this->exe_ext) . ')$/', $pathinfo_files[1], $matches)) {
                    $this->action_file = $pathinfo_dir . ucfirst($matches[1]) . $this->exe_ext;
                } else {
                    $this->action_file = $pathinfo_dir . ucfirst($pathinfo_files[1]) . $this->exe_ext;
                }
            }
        }

        // ƥץ졼ȥե
        $this->setTemplateFile(substr($this->action_file, 0, intval('-' . strlen($this->exe_ext))) . SYL_ROUTER_URL_EXT);

        $action_method = null;
        // ᥽åͤѥ᡼Υ
        if (($action_method === null) && ((SYL_ROUTER_EXTRA_ACTION == '1') || (SYL_ROUTER_EXTRA_ACTION == '3'))) {
            $reg = '/^' . preg_quote(SYL_ACTION_KEY) . '_(.+)(_x|_y)?$/';
            foreach ($data->gets() as $name => $value) {
                if (preg_match($reg, $name, $matches)) {
                    $action_method = $matches[1];
                    break;
                }
            }
        }
        // ͤѥ᡼ͤ
        if (($action_method === null) && ((SYL_ROUTER_EXTRA_ACTION == '2') || (SYL_ROUTER_EXTRA_ACTION == '3'))) {
            $action_method = $data->get(SYL_ACTION_KEY);
        }
        // ֤
        if ($action_method !== null) {
            $this->action_method = ucfirst($action_method);
        }

        // ꥸʥ륢ե
        $this->action_file_org = $this->action_file;

/*
echo "action_method: " . $this->action_method . "<br>";
echo "action_file: " . $this->action_file . "<br>";
echo "template file: " . $this->template_file  . "<br>";
exit;
*/
    }

}

?>
