<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.24 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܾ󥯥饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Router.php';
/**
 * PHPեɥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Loader.php';

/**
 * ե졼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.24 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Context
{
    /**
     * ӥ塼
     * 
     * @access abstract
     * @var string
     */
    var $view_type = '';
    /**
     * 롼֥
     * 
     * @access protected
     * @var string
     */
    var $router = null;
    /**
     * ѥ᡼
     * 
     * @access protected
     * @var string
     */
    var $parameters = array();
    /**
     * executeե¹ԥե饰
     * 
     * @access protected
     * @var bool
     */
    var $is_execute = true;
    /**
     * å奿ॢ[s]
     * 
     * @access private
     * @var int
     */
    var $cache_lifetime = 3600;
    /**
     * å奪֥
     * 
     * @access private
     * @var object
     */
    var $cache = null;

    /**
     * 󥹥ȥ饯
     *
     * @access protected
     * @param object ǡ֥
     */
    function SyL_Context(&$data)
    {
        $this->router =& SyL_Router::factory($data);
        if (!$this->router->getViewType()) {
            $this->router->setViewType($this->view_type);
        }

//print_r($this->router);
        if (SYL_CACHE) {
            $this->cache =& SyL_Cache::factory('file');
            $this->cache->setPrefix(SYL_APP_NAME . '.');
            $this->cache->setCacheDir(SYL_CACHE_FILE_DIR . '/app/');
        }
    }

    /**
     * ƥȤ
     *
     * @access public
     * @param object ǡ֥
     */
    function &singleton(&$data)
    {
        static $singleton;
        if (!is_object($singleton)) {
            $class_name = 'SyL_Context' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Context/{$class_name}.php";
            // ҥ饹Υ󥹥
            $singleton = new $class_name($data);
        }
        return $singleton;
    }

    /**
     * 롼֥Ȥ
     *
     * @access public
     * @return object 롼֥
     */
    function &getRouter()
    {
        return $this->router;
    }

    /**
     * executeե¹Ƚ
     *
     * @access public
     * @return bool executeե¹ԥե饰
     */
    function isExecute()
    {
        return $this->is_execute;
    }

    /**
     * ݡͥȥ֥Ȥ򥻥å
     * 
     * @access public
     * @param string ݡͥ̾
     * @return object ݡͥ
     */
    function &getComponent($name)
    {
        $container =& SyL_Container::singleton();
        return $container->getComponent($name);
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param mixed ѥ᡼
     */
    function setParameter($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ѥ᡼
     */
    function &getParameters()
    {
        return $this->parameters;
    }


    // -----------------------------------------------------
    // DBϢ̥᥽å
    // -----------------------------------------------------

    /**
     * DB֥Ȥ
     *
     * @access protected
     * @param string DSNʸ
     * @return object DB֥
     */
    function &getDB($dsn='')
    {
        static $dsns = array();
        if (!isset($dsns[$dsn])) {
            SyL_Loggers::info("getDB for Action");
            // DB饹󥯥롼
            include_once SYL_INCLUDE_DIR . '/lib/SyL_DB.php';
            // DB֥ȼ
            $dsns[$dsn] =& SyL_DB::getConnection($dsn);
            $dsns[$dsn]->setCallbackSqlLog(array(__CLASS__, 'addLogDBSql'));
            $dsns[$dsn]->setCallbackErrorLog(array(__CLASS__, 'addLogDBError'));
            //register_shutdown_function(array(&$dsns[$dsn], 'closeConnection'));
        }
        return $dsns[$dsn];
    }

    /**
     * DB֥Ȥ³
     *
     * @access protected
     * @param object DB֥
     */
    function closeDB(&$conn)
    {
        if (is_object($conn)) {
            SyL_Loggers::info("DB connection end");
            $conn->closeConnection();
            $conn = null;
        }
    }

    /**
     * SQL˵Ͽ
     *
     * @static
     * @access private
     * @param string å
     */
    function addLogDBSql($message)
    {
        SyL_Loggers::debug($message);
    }

    /**
     * DB顼˵Ͽ
     *
     * @static
     * @access private
     * @param string å
     */
    function addLogDBError($message)
    {
        SyL_Loggers::warn($message);
    }


    // -----------------------------------------------------
    // å嶦̥᥽å
    // -----------------------------------------------------

    /**
     * å֤ͭ򥻥åȤ
     *
     * @access public
     * @param int åͭ
     */
    function setCacheLifetime($lifetime)
    {
        $this->cache_lifetime = $lifetime;
    }

    /**
     * å
     *
     * @access public
     * @param string åΥ
     */
    function getCache($key)
    {
        $this->cache->setKey($key);
        $this->cache->setLifeTime($this->cache_lifetime);
        return $this->cache->read();
    }

    /**
     * å򥻥åȤ
     *
     * @access public
     * @param string åΥ
     * @param mixed åǡ
     */
    function setCache($key, $data)
    {
        $this->cache->setKey($key);
        $this->cache->setLifeTime($this->cache_lifetime);
        $this->cache->write($data);
    }


    // -----------------------------------------------------
    // ǧڴϢ̥᥽å
    // -----------------------------------------------------

    /**
     * 桼֥Ȥ
     *
     * @access protected
     * @return object 桼֥
     */
    function &getUser()
    {
        // AUTH饹󥯥롼
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        return $auth->getUser();
    }

    /**
     * 桼֥Ȥ
     *
     * @access protected
     * @return object 桼֥
     */
    function setUser(&$user)
    {
        // AUTH饹󥯥롼
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        $auth->setUser($user);
    }

    /**
     * Ȥ
     *
     * @access protected
     */
    function doLogout()
    {
        // AUTH饹󥯥롼
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        $auth->doLogout();
    }
}

?>
