<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.38 2008/11/09 10:05:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Хåե
 */
ob_start();
ob_implicit_flush(0);

/**
 * magic_quotes_runtime -> off
 */
set_magic_quotes_runtime(0);

/**
 * ե륯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Config.php';
/**
 * ƥʥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Container.php';

/**
 * ȥ饯饹
 *
 * Τνή
 * Ƥ
 *   DIƥʤݻ
 *   ήȼܥ٥Ƚ
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Controller.php,v 1.38 2008/11/09 10:05:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Controller
{
    /**
     * 顼ϥɥ᥽å̾
     * ''ξϥ顼ϥɥꤷʤ
     *
     * SyL_ErrorǻѤƤ
     *
     * @access public
     * @var string
     */
    var $error_handler_method = 'errorStream';
    /**
     * 㳰ϥɥ᥽å̾
     * ''ξ㳰ϥɥꤷʤ
     *
     * SyL_ErrorǻѤƤ
     *
     * @access public
     * @var string
     */
    var $exception_handler_method = 'exceptionStream';
    /**
     * ˴᥽å̾
     * ''ξϽ˴᥽åɤꤷʤ
     *
     * @access private
     * @var string
     */
    var $destory_handler_method = 'finalStream';
    /**
     * 顼
     *
     * @access private
     * @var array
     */
    var $error = array();
    /**
     * ƥʥ֥
     *
     * @access private
     * @var object
     */
    var $container = null;

    /**
     * 󥹥ȥ饯
     *
     * @access protected
     * @param array Ķ
     */
    function SyL_Controller($config)
    {
        // ץꥱ̾
        if (!isset($config['app_name']) || !$config['app_name']) {
            trigger_error("[SyL error] App_name not found", E_USER_ERROR);
        }

        // 󥭡
        define('SYL_ACTION_KEY', (isset($config['action_key']) && $config['action_key']) ? $config['action_key'] : 'action');
        // ץȥǥ쥯ȥ
        define('SYL_PROJECT_DIR', $config['project_dir']);
        // ץեǥ쥯ȥ
        define('SYL_PROJECT_CONFIG_DIR',  SYL_PROJECT_DIR . '/config');
        // ץȥ饤֥ǥ쥯ȥ
        define('SYL_PROJECT_LIB_DIR',  SYL_PROJECT_DIR . '/lib');
        // ץꥱ̾
        define('SYL_APP_NAME', $config['app_name']);
        // ץꥱǥ쥯ȥ
        define('SYL_APP_DIR', SYL_PROJECT_DIR . '/apps/' . SYL_APP_NAME);
        // ץꥱեǥ쥯ȥ
        define('SYL_APP_CONFIG_DIR', SYL_APP_DIR . '/config');
        // ץꥱ饤֥ǥ쥯ȥ
        define('SYL_APP_LIB_DIR', SYL_APP_DIR . '/lib');

        // å
        define('SYL_CACHE', (isset($config['cache']) && $config['cache']));
        define('SYL_CACHE_FILE_DIR', SYL_PROJECT_DIR . '/var/cache/' . SYL_APP_NAME . '/');

        // PHPƥ२顼¸
        // ȤǥƤʤ硢¸
        if (!isset($config['syslog']) || $config['syslog']) {
            if (!ini_get('log_errors')) {
                ini_set('log_errors', true);
                ini_set('error_log', SYL_PROJECT_DIR . '/var/syslogs/' . SYL_APP_NAME . '/phperror_' . date('Ymd') . '.log');
            }
        }

        // ɤ߹
        SyL_Config::get();

        // ƥ
        $this->container =& SyL_Container::singleton();
        $this->container->setComponent('controller', $this);

        // shutdownϥɥ
        if ($this->destory_handler_method != '') {
            register_shutdown_function(array(&$this, $this->destory_handler_method));
        }
    }

    /**
     * ȥݥ
     *
     * @static
     * @access public
     * @param array Ķ
     */
    function streaming($config)
    {
        if (isset($config['type']) && $config['type']) {
            define('SYL_ENV_TYPE', strtolower($config['type']));
        } else {
            if ((PHP_SAPI == 'cgi') && !isset($_SERVER['REQUEST_METHOD'])) {
                trigger_error("[SyL error] Command line SAPI is CLI only", E_USER_ERROR);
            } else if (PHP_SAPI == 'cli') {
                define('SYL_ENV_TYPE', 'cmd');
            } else {
                define('SYL_ENV_TYPE', 'web');
            }
        }
        $class_name = 'SyL_Controller' . ucfirst(SYL_ENV_TYPE);
        include_once SYL_INCLUDE_DIR . "/framework/Controller/{$class_name}.php";
        $singleton = new $class_name($config);
        $singleton->stream();
    }

    /**
     * 
     *
     * @access protected
     */
    function initStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('initStream', 'components');

        // ꥯȽ
        if (SYL_ENV_TYPE == 'cmd') {
            $script_file = isset($_SERVER['SCRIPT_FILENAME']) ? $_SERVER['SCRIPT_FILENAME'] : '';
            SyL_Loggers::info("cmd start: {$script_file}");
        } else {
            $method = isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : '';
            $addr   = isset($_SERVER['REMOTE_ADDR'])    ? $_SERVER['REMOTE_ADDR']    : '';
            $uri    = isset($_SERVER['REQUEST_URI'])    ? $_SERVER['REQUEST_URI']    : '';
            SyL_Loggers::info("request start: \"{$method}: {$uri}\" - {$addr}");
        }
    }

    /**
     * ¹
     *
     * @access protected
     */
    function loadStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('loadStream', 'filters');
    }

    /**
     * ¹
     *
     * @access protected
     */
    function executeStream()
    {
        $context =& $this->container->getComponent('context');
        if ($context->isExecute()) {
            // ٥ȼ¹
            $this->raiseEvent('executeStream', 'actions');
        }
    }

    /**
     * ӥ塼ɽ¹
     *
     * @access protected
     */
    function middleStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('middleStream');
    }

    /**
     * ӥ塼ɽ
     *
     * @access protected
     */
    function renderStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('renderStream');
    }

    /**
     * ӥ塼ɽ¹Ը
     *
     * @access protected
     */
    function unloadStream()
    {
        // ٥ȼ¹
        $this->raiseEvent('unloadStream');
    }

    /**
     * ǽ
     * register_shutdown_function
     *
     * @access protected
     */
    function finalStream()
    {
        // ̥ǥХå
        if (function_exists('memory_get_usage') && class_exists('SyL_Loggers')) {
            $debug = 'Memory Status  current: ' . number_format(floor(memory_get_usage()/1024)) . 'KB';
            if (function_exists('memory_get_peak_usage')) {
                $debug .= ' max: ' . number_format(floor(memory_get_peak_usage()/1024)) . 'KB';
            }
            SyL_Loggers::debug($debug);
        }

        // ٥ȼ¹
        $this->raiseEvent('finalStream');
    }

    /**
     * 㳰ϥɥ¹Խ
     *
     * @access protected
     * @param object 㳰֥
     */
    function exceptionStream($ex)
    {
        $this->errorStream(E_USER_ERROR, $ex->getMessage(), $ex->getFile(), $ex->getLine(), array(), $ex->getTrace());
    }

    /**
     * 顼ϥɥ¹Խ
     *
     * @access protected
     * @param int 顼Υ٥
     * @param string 顼å
     * @param string ե
     * @param int ֹ
     * @param array ƥ
     * @param array Хåȥ졼
     */
    function errorStream()
    {
        static $num = 1;
        // ߤΥ顼٥뤫饨顼̤ɽ뤫Ƚ
        if (func_get_arg(0) & error_reporting()) {
            if ($num++ > 1) {
                $error_message = "[SyL error] Error handler trigger 2";
                SyL_Loggers::warn($error_message);
                echo $error_message;
                exit;
            }

            for ($i=0; $i<5; $i++) {
                $this->error[$i] = func_get_arg($i);
            }
            if (func_num_args() == 6) {
                $this->error[5] = func_get_arg(5);
            } else {
                $this->error[5] = debug_backtrace();
                // errorStream()᥽åɤϺ
                array_shift($this->error[5]);
            }

            if (count($this->error[5]) > 0) {
                if (!isset($this->error[5][0]['file'])) {
                    $this->error[5][0]['file'] = $this->error[2];
                }
                if (!isset($this->error[5][0]['line'])) {
                    $this->error[5][0]['line'] = $this->error[3];
                }
            }

            // ٥ȼ¹
            $this->raiseEvent('errorStream');
            exit;
        } else {
            $error_message = "[SyL_error] Background logging out of error_reporting. level: " . func_get_arg(0) . " message: " . func_get_arg(1) . " file: " . func_get_arg(2) . " line: " . func_get_arg(3);
            SyL_Loggers::notice($error_message);
        }
    }

    /**
     * ¹ԴĶȤΥե
     *
     * @access abstract
     */
    function stream()
    {
    }

    /**
     * ٥ȼ¹
     *
     * @access protected
     * @param string ٥ȥ᥽å̾
     * @param string ե̾
     */
    function raiseEvent($event, $config_type='')
    {
        $this->container->raiseEvent($event, $config_type);
    }

    /**
     * 顼No
     * 
     * @access public
     * @return string 顼No
     */
    function getErrorNo()
    {
        return isset($this->error[0]) ? $this->error[0] : '';
    }

    /**
     * 顼ե
     * 
     * @access public
     * @return string 顼ե
     */
    function getErrorFile()
    {
        return isset($this->error[2]) ? $this->error[2] : '';
    }

    /**
     * 顼Կ
     * 
     * @access public
     * @return string 顼Կ
     */
    function getErrorLine()
    {
        return isset($this->error[3]) ? $this->error[3] : '';
    }

    /**
     * 顼å
     * 
     * @access public
     * @return string 顼å
     */
    function getErrorMessage()
    {
        $error_message = isset($this->error[1]) ? $this->error[1] : '';
        if ($error_message) {
            $error_message .= ' (' . $this->getErrorFile() . ' on line ' . $this->getErrorLine()  . ')';
        }
        return $error_message;
    }

    /**
     * 顼ȯǤΤ٤ƤѿƤ
     * 
     * @access public
     * @return array 顼ƥ
     */
    function getErrorContext()
    {
        return isset($this->error[4]) ? $this->error[4] : array();
    }

    /**
     * 顼ȯǥХåȥ졼
     * 
     * @access public
     * @return array ǥХåȥ졼
     */
    function getErrorTrace()
    {
        return isset($this->error[5]) ? $this->error[5] : array();
    }
}

?>
