<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loader.php,v 1.8 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SyLե졼бPHPեΥɥ饹
 *
 * SyL_DB.php
 *   => SyL_Loader::lib('DB');
 * DB/SyL_DBSqlBuilder.php
 *   => SyL_Loader::lib('DB.SqlBuilder');
 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Loader.php,v 1.8 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Loader
{
    /**
     * 饤֥ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @param string 饹Ƭ
     * @param string ĥ
     * @param bool 顼ȥꥬե饰
     */
    function userLib($path, $prefix='', $ext='php', $trigger=true)
    {
/*
        if ($prefix == 'SyL') {
            SyL_Loader::lib($path);
        } else {
*/
            $path = SyL_Loader::convertPath($path, $prefix, $ext);
            // ץꥱ饤֥ǥ쥯ȥ
            $base1 = SYL_APP_LIB_DIR . $path;
            if (SyL_Loader::load($base1)) return;
            // ץȥ饤֥ǥ쥯ȥ
            $base2 = SYL_PROJECT_LIB_DIR . $path;
            if (SyL_Loader::load($base2)) return;

            if ($trigger) {
                trigger_error("[SyL error] Library file not found ({$base1} or {$base2})", E_USER_ERROR);
            }
//        }
    }

    /**
     * ե졼ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     */
    function fw($path)
    {
        $path = SYL_INCLUDE_DIR . '/framework' . SyL_Loader::convertPath($path, 'SyL');
        if (!SyL_Loader::load($path)) {
            trigger_error("[SyL error] Framework file not found ({$path})", E_USER_ERROR);
        }
    }

    /**
     * ե졼饤֥ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     */
    function lib($path)
    {
        $path = SYL_INCLUDE_DIR . '/lib' . SyL_Loader::convertPath($path, 'SyL');
        if (!SyL_Loader::load($path)) {
            trigger_error("[SyL error] Framework Library file not found ({$path})", E_USER_ERROR);
        }
    }

    /**
     * ǥ쥯ȥ꤫PHPեɤ
     * 
     * @static
     * @access public
     * @param string ɥե
     * @return bool true: OKfalse: NG
     */
    function load($path)
    {
        if (is_file($path) && is_readable($path)) {
            return (include_once $path);
        } else {
            return false;
        }
    }

    /**
     * SyL饤֥Ѥ˥ѥѴ
     * 
     * @static
     * @access public
     * @param string ѥ
     * @param string ĥ
     * @return string Ѵѥ
     */
    function convertPath($path, $prefix='', $ext='php')
    {
        $classname = SyL_Loader::convertClass($path, false, $prefix);
        $path = array_map('ucfirst', explode('.', $path));
        array_pop($path); // ե
        $path = implode('/', $path);
        if ($path == '') {
            return "/{$classname}.{$ext}";
        } else {
            return "/{$path}/{$classname}.{$ext}";
        }
    }

    /**
     * ѥSyL饤֥ꥯ饹̾
     * 
     * @static
     * @access public
     * @param string ѥ
     * @param bool 󥯥롼ɥե饰
     * @param string Ƭ
     */
    function convertClass($path, $load=false, $prefix='')
    {
        if ($load) {
            SyL_Loader::userLib($path, $prefix);
        }
        if ($prefix) {
            $prefix .= '_';
        }
        return $prefix . implode('', array_map('ucfirst', explode('.', $path)));
    }
}

?>
