<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.28 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ɽ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_View.php,v 1.28 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_View
{
    /**
     * ƥĥ
     * 
     * @access protected
     * @var string
     */
    var $content_type = '';
    /**
     * ƥ̽Ƚ
     * 
     * @access protected
     * @var bool
     */
    var $content_length = SYL_RESPONSE_LENGTH;
    /**
     * gzipȽ
     * 
     * @access protected
     * @var bool
     */
    var $gzip_compress = SYL_RESPONSE_GZIP;
    /**
     * ɽƤΥǡ
     * 
     * @access protected
     * @var string
     */
    var $render = '';
    /**
     * ե졼饹
     * 
     * @access protected
     * @var object
     */
    var $context = null;
    /**
     * 롼饹
     * 
     * @access protected
     * @var object
     */
    var $router = null;
    /**
     * ե졼ǡݻ饹
     * 
     * @access protected
     * @var object
     */
    var $data = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ǡ֥
     */
    function SyL_View(&$context, &$data)
    {
        $this->context =& $context;
        $this->data    =& $data;
        $this->router  =& $context->getRouter();
    }

    /**
     * ƥץ졼ȥ֥Ȥ
     * 
     * @access public
     * @param object ǡ֥
     * @param object ݡͥȥ᥽åɥ֥
     * @return object ӥ塼֥
     */
    function &getObject(&$context, &$data)
    {
        $router =& $context->getRouter();

        $view      = null;
        $type      = $router->getViewType();
        $classname = '';
        $classfile = '';

        if (!$type || (SYL_ENV_TYPE == 'cmd')) {
            // Nullӥ塼
            $classname = 'SyL_ViewNull';
            $classfile = SYL_INCLUDE_DIR . "/framework/View/{$classname}.php";
        } else {
            $classname = 'SyL_View' . implode('', array_map('ucfirst', explode('.', $type)));
            $classfile = SYL_INCLUDE_DIR . "/framework/View/{$classname}.php";
        }

        if (!is_file($classfile)) {
            trigger_error("[SyL error] {$type} View file not found ({$classfile})", E_USER_ERROR);
        }

        include_once $classfile;
        $view =& new $classname($context, $data);

        SyL_Loggers::debug("view info env: " . SYL_ENV_TYPE . " type: {$type} class: {$classname} file: {$classfile}");

        return $view;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ롼Ȥ
     *
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ롼
     */
    function getTemplateDir()
    {
        return $this->router->getTemplateDir();
    }

    /**
     * ƥץ졼ȥե
     *
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        return $this->router->getTemplateFile();
    }

    /**
     * ƥĥפ򥻥å
     * 
     * @access public
     * @param string ƥĥ
     */
    function setContentType($content_type)
    {
        $this->content_type = $content_type;
    }

    /**
     * ƥĥפ
     * 
     * @access public
     * @return string ƥĥ
     */
    function getContentType()
    {
        return $this->content_type;
    }

    /**
     * ƥ̽Ƚ
     * 
     * @access public
     * @return bool ƥ̽Ƚ
     */
    function isContentLength()
    {
        return (bool)$this->content_length;
    }

    /**
     * gzipȽ
     * 
     * @access public
     * @return bool gzipȽ
     */
    function isGzipCompress()
    {
        return (bool)$this->gzip_compress;
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ӥ塼Ϥѥ᡼
     */
    function &getActionValues()
    {
        $values  = array();
        $values += $this->context->getParameters();
        $values += $this->data->finalOutputs();

        return $values;
    }

    /**
     * ɽƤ򥻥å
     * 
     * @access protected
     * @param string ɽ
     */
    function setRender(&$render)
    {
        $this->render =& $render;
    }

    /**
     * ɽƤ
     * 
     * @access public
     * @return string HTML
     */
    function &getRender()
    {
        return $this->render;
    }

    /**
     * HTML󥰼¹
     * 
     * @access abstract
     */
    function render()
    {
    }
}

?>
