<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayout.php,v 1.12 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤ȥӥ塼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayout.php,v 1.12 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewLayout extends SyL_View
{
    /**
     * 쥤ե
     * 
     * @access private
     * @var array
     */
    var $config = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ƥȥ֥
     * @param object ǡ֥
     */
    function SyL_ViewLayout(&$context, &$data)
    {
        parent::SyL_View($context, $data);

        $config =& SyL_Config::factory('layouts');
        $config->setRouter($context->getRouter());
        $config->parseXml();
        $this->config = $config->getConfig();

        // ƥץ졼ȥѥ
        if ($this->config['file'][0] == '/') {
            $this->config['file'] = substr($this->config['file'], 1);
        }

        // ƥĥפ򥻥å
        $this->setContentType('text/html; charset=' . SYL_ENCODE_INTERNAL);
    }

    /**
     * 쥤ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getLayoutFile()
    {
        return $this->config['file'];
    }

    /**
     * ʬƥץ졼ȥե
     * 
     * @access public
     * @return array ʬƥץ졼ȥե
     */
    function getTemplateFiles()
    {
        return $this->config['templates'];
    }

    /**
     * ƥĥե
     * 
     * @access public
     * @return string ƥĥե
     */
    function getContentFile()
    {
        return $this->router->getTemplateFile();
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ӥ塼Ϥѥ᡼
     */
    function &getActionValues()
    {
        $values =& parent::getActionValues();

        // 쥤
        if (isset($this->config['templates'])) {
            $values += $this->getTemplateFiles();
        }
        if (isset($this->config['content']) && $this->config['content']) {
            $values[$this->config['content']] = $this->getContentFile();
        } else {
            SyL_Loggers::notice("Content context not found");
        }
        if (isset($this->config['params'])) {
            $values += $this->config['params'];
        }

        return $values;
    }
}

?>
