<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutDefault.php,v 1.10 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤ȥӥ塼饹
 */
require_once 'SyL_ViewLayout.php';

/**
 * ǥեȥ쥤ȥӥ塼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutDefault.php,v 1.10 2008/12/01 17:45:52 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewLayoutDefault extends SyL_ViewLayout
{
    /**
     * 쥤ȥեХѥѴƤ
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getLayoutFile()
    {
        return $this->router->getTemplateDir() . $this->config['file'];
    }

    /**
     * ʬƥץ졼ȥեХѥѴƤ
     * 
     * @access public
     * @return array ʬƥץ졼ȥե
     */
    function getTemplateFiles()
    {
        $template_files = array();
        foreach ($this->config['templates'] as $name => $value) {
            $template_files[$name] = $this->router->getTemplateDir() . $value;
        }
        return $template_files;
    }

    /**
     * ƥĥեХѥѴƤ
     * 
     * @access public
     * @return string ƥĥե
     */
    function getContentFile()
    {
        return $this->router->getTemplateDir() . $this->router->getTemplateFile();
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        // 󤫤Υѥ᡼
        $values =& $this->getActionValues();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key])) {
                $$key =& $values[$key];
            } else {
                $$key = $values[$key];
            }
        }

        // ɽƤ򥻥å
        ob_start();
        include_once $this->getLayoutFile();
        $this->setRender(ob_get_clean());
    }
}

?>
