<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverSybase.php,v 1.4 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹MSSQL, Sybase
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverSybase.php,v 1.4 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDriverSybase extends SyL_DB
{
    /**
     * 󥳡ɥե饰
     *
     * @access private
     * @var bool
     */
    var $client_encode_flag = false;
    /**
     * DBС󥳡
     * 
     * @access protected
     * @var string
     */
    var $server_encode = 'sjis-win';

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $host_tmp = $host;
        if (!$host_tmp) $host_tmp  = 'localhost';
        if ($port)      $host_tmp .= ':' . $port;

        if ($this->client_encode) {
            $this->connection = $persistent ? sybase_pconnect($host_tmp, $user, $passwd, $this->client_encode) : sybase_connect($host_tmp, $user, $passwd, $this->client_encode);
            $this->client_encode_flag = true;
        } else {
            $this->connection = $persistent ? sybase_pconnect($host_tmp, $user, $passwd) : sybase_connect($host_tmp, $user, $passwd);
        }
        return (is_resource($this->connection) && sybase_select_db($dbname, $this->connection));
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            sybase_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    function setClientEncoding($client_encode, $server_encode='')
    {
        $this->client_encode_flag = false;
        parent::setClientEncoding($client_encode, $server_encode);
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        if ($code) {
            parent::setErrorMessage($code, $message);
        } else {
            $message = sybase_get_last_message();
            if ($message) {
                $this->last_error_code    = '9999';
                $this->last_error_message = $message;
            }
        }
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return str_replace("'", "''", $parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        parent::beginTransaction();
        @sybase_query('BEGIN TRAN', $this->connection);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        @sybase_query('ROLLBACK TRAN', $this->connection);
        parent::rollBack ();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        @sybase_query('COMMIT TRAN', $this->connection);
        parent::commit();
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execRef($sql, &$result)
    {
        if (!$this->client_encode_flag) {
            $this->convertEncoding($sql);
        }
        parent::execRef($sql, $result);
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        $result = @sybase_query($sql, $this->connection);
        if ($result !== false) {
            return $result;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        $result = @sybase_query($sql, $this->connection);
        if ($result !== false) {
            return sybase_affected_rows($this->connection);
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        $result = @sybase_query($sql, $this->connection);
        if ($result !== false) {
            return true;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $query);

        // Ƚ
        if (!is_resource($query)) {
            $data = $query;
            return ($query !== false);
        }

        switch ($get) {
        case 'one':
            if (sybase_num_rows($query) > 0) {
                list($data) = sybase_fetch_row($query);
            } else {
                $data = '';
            }
            break;
        case 'record':
            $data = sybase_fetch_assoc($query);
            if ($data === false) {
                $data = array();
            } else {
                $data = $this->caseFieldName($data);
            }
            break;
        case 'all':
            $data = array();
            while ($result = sybase_fetch_assoc($query)) {
                $data[] = $this->caseFieldName($result);
            }
            break;
        }
        sybase_free_result($query);

        if (!$this->client_encode_flag) {
            $this->convertDecoding($data);
        }
        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        if (preg_match('/^select\s+(.+)order\s+by(.+)$/i', $sql, $matches)) {
            // ڡ󥰥֥
            $pager = $this->getPager($limit, $page);
            // SQL
            $sql_count = "SELECT COUNT(*) FROM (SELECT " . $matches[1] . ") AS SyL$";
            // SQL¹
            if (!$this->queryRef($sql_count, $record, 'one')) return false;
            $pager->setCountAll($record);

            // ڡñ̥쥳ɼ
            $sql_page = trim($sql);

            $sort_asc  = $matches[2];
            $sort_desc = '';
            foreach (array_map('trim', explode(',', $sort_asc)) as $column) {
                $column = explode(' ', $column);
                $sort = 'DESC';
                $i = 1;
                while (isset($column[$i])) {
                    switch (strtoupper($column[$i])) {
                    case 'ASC':  $sort = 'DESC'; break 2;
                    case 'DESC': $sort = 'ASC';  break 2;
                    }
                    $i++;
                }
                if ($sort_desc != '') {
                    $sort_desc .= ', ';
                }
                $sort_desc .= $column[0] . ' ' . $sort;
            }

            $num = 0;
            if ($pager->getCurrentPage() >= $pager->getTotalPage()) {
                $num = $pager->getCountAll() % $pager->getCount();
            } else {
                $num = $pager->getCount();
            }

            $sql_page  = "";
            $sql_page .= "SELECT * FROM (";
            $sql_page .=   "SELECT TOP " . $num . " * FROM (";
            $sql_page .=     "SELECT TOP " . ($pager->getCount() + $pager->getStartOffset()) . " ";
            $sql_page .=     $matches[1] . ' ORDER BY ' . $sort_asc;
            $sql_page .=   ") AS SyL1$ ";
            $sql_page .=   "ORDER BY ";
            $sql_page .=     $sort_desc;
            $sql_page .= ") AS SyL2$ ";
            $sql_page .= "ORDER BY ";
            $sql_page .=   $sort_asc;
        } else {
            trigger_error("[SyL error] Mssql SQL invalid [require `order by'] ({$sql_page})", E_USER_ERROR);
        }

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    function getVersion()
    {
        $sql = "SELECT @@VERSION";
        $this->queryRef($sql, $version, 'one');
        return $version;
    }
}

?>
