/**
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!SyL) var SyL = {};
if (!SyL.UI) SyL.UI = {};
if (!SyL.UI.Form) SyL.UI.Form = {};

/**
 * ե९饹
 */
SyL.UI.Form.Login = function(id, url)
{
  if (!id || !document.getElementById(id)) {
    throw "[SyL.UI.Form.Login] Requre div id";
  }

  if (!url) {
    url = window.location.pathname;
  }

  this.onsubmit = null;

  this.userNameLabel = "Username: ";
  this.passwordNameLabel = "Password: ";
  this.userName = "username";
  this.passwordName = "password";

  this.submitName = "OK";

  this.tableClass    = "syl-ui-login";
  this.errorMessageClass = "syl-ui-login-errormessage";
  this.userTextClass = "syl-ui-login-usertext";
  this.userPasswordClass = "syl-ui-login-passwordtext";

  this.autoFocus = true;

  this.initialize(url, id);
}

SyL.UI.Form.Login.prototype = {
  initialize: function(url, id)
  {
    var self = this;

    var ajax = false;

    var form = null;

    var key  = "";
    var hashFunc = "";

    var errorMessageTimer = null;

    var preLoginCallback = null;
    var postLoginCallback = null;

    var className = (/*@cc_on!@*/false) ? "className" : "class";

    this.setAjax = function (ajaxt)
    {
      if (typeof(SyL.Ajax) == "undefined") {
        throw "[SyL.UI.Form.Login.setAjax] SyL.Ajax package not imported";
      }
      ajax = !!ajaxt;
    };
    this.setPasswordHash = function (keyt, func)
    {
      key = keyt;
      if (typeof(func) == "function") {
        hashFunc = func;
      } else {
        throw "[SyL.UI.Form.Login.setHash] Invalid parameter (" + func + ")";
      }
    };
    this.setPreLoginCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        preLoginCallback = callback;
      } else {
        throw "[SyL.UI.Form.Login.setPreLoginCallback] Invalid parameter (" + callback + ")";
      }
    };
    this.setPostLoginCallback = function(callback)
    {
      if (typeof(callback) == "function") {
        postLoginCallback = callback;
      } else {
        throw "[SyL.UI.Form.Login.setPostLoginCallback] Invalid parameter (" + callback + ")";
      }
    };

    this.create = function(formId, userValue, passwordValue)
    {
      if (typeof(userValue) == "undefined") {
        userValue = "";
      }
      if (typeof(passwordValue) == "undefined") {
        passwordValue = "";
      }

      var div = document.getElementById(id);

      var dive = document.createElement("div");
      dive.setAttribute(className, this.errorMessageClass);
      dive.style.display = "none";
      dive.innerHTML = "&nbsp;";

      form  = document.createElement("form");
      if (formId) {
        form.id   = formId;
        form.name = formId;
      }
      form.style.padding = "0px";
      form.style.margin  = "0px";
      form.method = "POST";
      form.action = url;
      form.onsubmit = function() {
        return self.submit(this);
      };
      var table = document.createElement("table");
      table.setAttribute(className, this.tableClass);
      var tbody = document.createElement("tbody");
      var tr = document.createElement("tr");
      var th = document.createElement("th");
      th.innerHTML = this.userNameLabel;
      tr.appendChild(th);
      var td = document.createElement("td");
      this.createUserText(td, userValue);
      tr.appendChild(td);
      tbody.appendChild(tr);

      var tr = document.createElement("tr");
      var th = document.createElement("th");
      th.innerHTML = this.passwordNameLabel;
      tr.appendChild(th);
      var td = document.createElement("td");
      this.createPasswordText(td, passwordValue);
      tr.appendChild(td);
      tbody.appendChild(tr);

      var tr = document.createElement("tr");
      var td = document.createElement("td");
      td.colSpan = "2";
      td.style.textAlign = "right";
      var input = document.createElement("input");
      input.type  = "submit";
      input.value = this.submitName;
      td.appendChild(input);
      tr.appendChild(td);
      tbody.appendChild(tr);

      form.appendChild(table);
      table.appendChild(tbody);
      div.appendChild(dive);
      div.appendChild(form);

      if (this.autoFocus) {
        this.focusInput();
      }
    };

    this.createUserText = function(element, value)
    {
      if (typeof(element) != "object") {
        throw "[SyL.UI.Form.Login.createUserText] Invalid parameter format (" + typeof(element) + ")";
      }
      var input = document.createElement("input");
      input.setAttribute(className, this.userTextClass);
      input.type  = "text";
      input.name  = this.userName;
      input.value = value;
      element.appendChild(input);
    };

    this.createPasswordText = function(element, value)
    {
      if (typeof(element) != "object") {
        throw "[SyL.UI.Form.Login.createPasswordText] Invalid parameter format (" + typeof(element) + ")";
      }
      var input   = document.createElement("input");
      input.setAttribute(className, this.userPasswordClass);
      input.type  = "password";
      input.name  = this.passwordName;
      input.value = value;
      element.appendChild(input);
    };

    this.getUserElement = function()
    {
      return getElement(this.userName);
    };

    this.getPasswordElement = function()
    {
      return getElement(this.passwordName);
    };

    function getElement(inputName)
    {
      if (form) {
        for (var i=0; i<form.elements.length; i++) {
          if (form.elements[i].name == inputName) {
            return form.elements[i];
          }
        }
      }
      return null;
    };

    this.submit = function()
    {
      var userValue     = getElement(this.userName).value;
      var passwordValue = getElement(this.passwordName).value;

      if (preLoginCallback && !preLoginCallback(userValue, passwordValue)) {
        return false;
      }

      this.enableSubmit(false);

      if (ajax) {
        if (key) {
          passwordValue = getPasswordHash(passwordValue);
        }
        requestAjax(userValue, passwordValue);
        return false;
      } else {
        var input = document.createElement("input");
        input.type  = "hidden";
        input.name  = this.userName;
        input.value = userValue;
        form.appendChild(input);

        var input = document.createElement("input");
        input.type  = "hidden";
        input.name  = this.passwordName;
        input.value = (key ? getPasswordHash(passwordValue) : passwordValue);
        form.appendChild(input);

        return true;
      }
    };

    this.focusInput = function()
    {
      var timer = setTimeout(function() {
        var user     = getElement(self.userName);
        var password = getElement(self.passwordName);

        if ((!user || user.value == "") || ((user && user.value != "") && (password && password.value != ""))) {
          user.focus();
        } else {
          password.focus();
        }
        clearTimeout(timer);
      }, 100);
    };

    this.enableSubmit = function(enable)
    {
      for (var i=0; i<form.elements.length; i++) {
          form.elements[i].disabled = !enable;
      }
    };

    function requestAjax(userValue, passwordValue)
    {
      var userinfo = {};
      userinfo[self.userName] = userValue;
      userinfo[self.passwordName] = passwordValue;

      SyL.Ajax.Request.sendAsyncPost(
        url,
        function(data){
          self.enableSubmit(true);
          if (self.autoFocus) {
            self.focusInput();
          }
          if (postLoginCallback) {
            postLoginCallback(data);
          }
        },
        userinfo
      );
    };

    function getPasswordHash(passwordValue)
    {
       return hashFunc(key + hashFunc(passwordValue));
    };

    this.displayErrorMessage = function (errorMessage, timeout)
    {
      var div = document.getElementById(id);
      if (errorMessage) {
        div.firstChild.style.display = "block";
        div.firstChild.innerHTML = errorMessage;

        if (typeof(timeout) != "number") {
          timeout = 0;
        }
        if (timeout > 0) {
          if (errorMessageTimer) {
            clearTimeout(errorMessageTimer);
            errorMessageTimer = null;
          }
          errorMessageTimer = setTimeout(function(){
            div.firstChild.style.display = "none";
            clearTimeout(errorMessageTimer);
            errorMessageTimer = null;
          }, timeout);
        }
      } else {
        div.firstChild.style.display = "none";
        div.firstChild.innerHTML = "";
      }
    };
  }
}


/**
 * ǥ饹
 */
SyL.UI.Form.Element = function(name, label, require)
{
  if (!name) {
    name = "";
  }
  if (!label) {
    label = name;
  }
  this.note = "";

  this.initialize(name, label, !!require);
}

SyL.UI.Form.Element.prototype = {
  initialize: function(name, label, require)
  {
    var errorMessage   = "";
    var errorImmediate = false;
    var source = null;

    var className = (/*@cc_on!@*/false) ? "className" : "class";

    this.getName = function()
    {
      return name;
    };

    this.setErrorMessage = function(message, immediate)
    {
      if (message) {
        errorMessage   = message;
        errorImmediate = !!immediate;
      }
    };

    this.setSource = function(sourcet)
    {
      source = sourcet;
    };

    this.IsErrorImmediate = function()
    {
      return errorImmediate;
    };

    this.getErrorMessage = function()
    {
      return errorMessage;
    };

    this.createInputText = function(attributes, value)
    {
      this.setSource(createInput("text", attributes, value));
    };

    this.createInputPassword = function(attributes, value)
    {
      this.setSource(createInput("password", attributes, value));
    };

    this.createInputFile = function(attributes)
    {
      this.setSource(createInput("file", attributes));
    };

    this.createInputCheckbox = function(attributes, value)
    {
      if (attributes && attributes["value"]) {
        if (value && (attributes["value"] == value)) {
          attributes["checked"] = "checked";
        }
      }
      this.setSource(createInput("checkbox", attributes, value));
    };

    this.createInputRadio = function(attributes, value)
    {
      if (attributes && attributes["value"]) {
        if (value && (attributes["value"] == value)) {
          attributes["checked"] = "checked";
        }
      }
      this.setSource(createInput("radio", attributes, value));
    };

    this.createInputHidden = function(attributes, value)
    {
      this.setSource(createInput("hidden", attributes, value));
    };

    this.createInputSubmit = function(attributes, value)
    {
      this.setSource(createInput("submit", attributes, value));
    };

    this.createInputReset = function(attributes, value)
    {
      this.setSource(createInput("reset", attributes, value));
    };

    this.createInputButton = function(attributes, value)
    {
      this.setSource(createInput("button", attributes, value));
    };

    this.createInputImage = function(attributes)
    {
      this.setSource(createInput("image", attributes));
    };

    function createInput(type, attributes, value)
    {
      if (!attributes) {
        attributes = {};
      }
      attributes["type"] = type;
      if (!attributes["name"] && name) {
        attributes["name"] = name;
      }
      if (!attributes["value"] && value) {
        attributes["value"] = value;
      } else {
        attributes["value"] = "";
      }
      var input = document.createElement("input");
      for (var attribute in attributes) {
        input[attribute] = attributes[attribute];
      }
      if (attributes["checked"]) {
        input.checked = true;
      }
      return input;
    };

    this.createSelect = function(attributes, options, value)
    {
      if (!attributes) {
        attributes = {};
      }
      if (!attributes["name"] && name) {
        attributes["name"] = name;
      }
      if (!(value instanceof Array)) {
        value = [value];
      }

      var select = document.createElement("select");
      for (var option in options) {
        var element = document.createElement("option");
        element.value = option;
        element.innerHTML = options[option];
        for (var i=0; i<value.length; i++) {
          if (value[i] == option) {
            element.defaultSelected = true;
            break;
          }
        }
        select.appendChild(element);
      }
      this.setSource(input);
    };

    this.createTextarea = function(attributes, value)
    {
      if (!attributes) {
        attributes = {};
      }
      if (!attributes["name"] && name) {
        attributes["name"] = name;
      }
      var textarea = document.createElement("textarea");
      for (var attribute in attributes) {
        textarea[attribute] = attributes[attribute];
      }
      if (value) {
        textarea.innerHTML = value;
      }
      this.setSource(textarea);
    };

    this.getLabel = function()
    {
      return label;
    };

    this.getLabelTh = function(errorColumnClass)
    {
      var th = document.createElement("th");
      if (errorColumnClass && this.getErrorMessage()) {
        th.setAttribute(className, errorColumnClass);
      }

      th.innerHTML = label;
      if (require) {
        th.innerHTML += "&nbsp;<span style='color: #CC0000'>*</font>";
      }
      return th;
    };

    this.getElementTd = function(noteClass, errorColumnClass, errorMessageClass)
    {
      var td = document.createElement("td");
      if (errorColumnClass && this.getErrorMessage()) {
        td.setAttribute(className, errorColumnClass);
      }
      if (source && typeof(source) == "object") {
        td.appendChild(source);
      } else {
        td.innerHTML = (source) ? source : "&nbsp;";
      }
      if (this.note) {
        var div = document.createElement("div");
        if (noteClass) {
          div.setAttribute(className, noteClass);
        }
        div.innerHTML = this.note;
        td.appendChild(div);
      }
      var message = this.getErrorMessage();
      if (message && errorMessageClass) {
        var div = document.createElement("div");
        div.setAttribute(className, errorMessageClass);
        div.innerHTML = message;
        td.appendChild(div);
      }
      return td;
    };

    this.getElement = function()
    {
      return source;
    };
  }
}


/**
 * ϥե९饹
 */
SyL.UI.Form.Input = function(id, nextUrl, prevUrl)
{
  if (!id || !document.getElementById(id)) {
    throw "[SyL.UI.Form.Input] Requre div id";
  }

  if (!nextUrl) {
    nextUrl = window.location.pathname;
  }
  if (!prevUrl) {
    prevUrl = nextUrl;
  }

  this.tableClass   = "syl-ui-input";
  this.noteClass    = "syl-ui-input-note";
  this.buttonsClass = "syl-ui-input-buttons";

  this.errorClass        = "syl-ui-input-error";
  this.errorHeaderClass  = "syl-ui-input-errorheader";
  this.errorFooterClass  = "syl-ui-input-errorfooter";
  this.errorMessageClass = "syl-ui-input-errormessage";
  this.errorColumnClass  = "syl-ui-input-errorcolumn";

  this.errorMessageType = "1";
  this.errorHeaderMessage = "";
  this.errorFooterMessage = "";

  this.viewAlert = false;
  this.viewConfirm = false;
  this.viewConfirmMessage = "ϿޤǤ";

  this.cols = 2;
  this.nextButtonName = "ء";
  this.prevButtonName = "ء";

  this.initialize(id, nextUrl, prevUrl);
}

SyL.UI.Form.Input.prototype = {
  initialize: function(id, nextUrl, prevUrl)
  {
    var self = this;

    var form = null;
    var submitFunc = null;

    var elements = {};

    var className = (/*@cc_on!@*/false) ? "className" : "class";

    this.addElement = function(element)
    {
      var name = element.getName();
      if (name) {
        elements[name] = element;
      }
    };

    this.onSubmit = function(func)
    {
      if (typeof(func) == "function") {
        submitFunc = func;
      } else {
        throw "[SyL.UI.Form.Input.onSubmit] Invalid parameter (" + typeof(func) + ")";
      }
    };

    this.create = function(formId)
    {
      var div = document.getElementById(id);

      form = document.createElement("form");
      if (formId) {
        form.id   = formId;
        form.name = formId;
      }
      form.style.padding = "0px";
      form.style.margin  = "0px";
      form.method = "POST";
      form.action = nextUrl;
      form.onsubmit = function() {
        if (submitFunc && !submitFunc(this)) {
          return false;
        }
        return (!this.viewConfirm || confirm(this.viewConfirmMessage));
      };

      var dive = document.createElement("div");
      dive.setAttribute(className, this.errorClass);

      if (this.errorMessageType == "1") {
        if (this.isError()) {
          var errorMessages = this.getErrorMessages();
          if (this.errorHeaderMessage) {
            var diveh = document.createElement("div");
            diveh.setAttribute(className, this.errorHeaderClass);
            diveh.innerHTML = this.errorHeaderMessage;
          }
          dive.appendChild(diveh);

          var divem = document.createElement("div");
          divem.setAttribute(className, this.errorMessageClass);
          divem.innerHTML = errorMessages.join("<br />");
          dive.appendChild(divem);

          if (this.errorFooterMessage) {
            var divef = document.createElement("div");
            divef.setAttribute(className, this.errorFooterClass);
            divef.innerHTML = this.errorFooterMessage;
            dive.appendChild(divef);
          }
        } else {
          dive.style.display = "none";
        }
      } else {
        if (this.errorHeaderMessage && this.isError()) {
          var diveh = document.createElement("div");
          diveh.setAttribute(className, this.errorHeaderClass);
          diveh.innerHTML = this.errorHeaderMessage;
          dive.appendChild(diveh);
        } else {
          dive.style.display = "none";
        }
      }
      form.appendChild(dive);

      var table = document.createElement("table");
      table.setAttribute(className, this.tableClass);
      var tbody = document.createElement("tbody");

      var i = 1;
      var tr;
      for (var name in elements) {
        if (i == 1) {
          var tr = document.createElement("tr");
        }

        tr.appendChild(elements[name].getLabelTh(this.errorColumnClass));
        if (this.errorMessageType == "2") {
          tr.appendChild(elements[name].getElementTd(this.noteClass, this.errorColumnClass, this.errorMessageClass));
        } else {
          tr.appendChild(elements[name].getElementTd(this.noteClass, this.errorColumnClass));
        }

        if (this.cols <= i) {
          tbody.appendChild(tr);
          i = 1;
        } else {
          i++;
        }
      }

      if (i > 1) {
        while (this.cols >= i) {
          tr.appendChild((new SyL.UI.Form.Element("&nbsp;")).getLabelTh());
          tr.appendChild((new SyL.UI.Form.Element("&nbsp;")).getElementTd(this.noteClass));
          i++;
        }
        tbody.appendChild(tr);
      }

      var tr = document.createElement("tr");
      var td = document.createElement("td");
      td.setAttribute(className, this.buttonsClass);
      td.colSpan = this.cols * 2;

      var input = new SyL.UI.Form.Element();
      input.createInputSubmit(null, this.nextButtonName);
      td.appendChild(input.getElement());

      if (this.prevButtonName) {
        td.appendChild(document.createTextNode(" "));

        var input = new SyL.UI.Form.Element();
        input.createInputButton({
          "onclick": function(){
            this.form.action=prevUrl;
            this.form.submit();
          }
        }, this.prevButtonName);
        td.appendChild(input.getElement());
      }
      tr.appendChild(td);
      tbody.appendChild(tr);

      table.appendChild(tbody);
      form.appendChild(table);
      div.appendChild(form);
    };

    this.isError = function()
    {
      return (this.getErrorMessages().length > 0);
    };

    this.getErrorMessages = function()
    {
      var errorMessages = [];
      for (var name in elements) {
        var errorMessage = elements[name].getErrorMessage();
        if (errorMessage) {
          errorMessages.push(errorMessage);
        }
      }
      return errorMessages;
    };

  }
}


/**
 * եmics
 */
SyL.UI.Form.Util = {
  changeDate: function (y, m, d, yv, mv, dv)
  {
    if (yv == '') {
      while(m.options.length) m.options[m.options.length - 1] = null;
      m.options[0] = new Option("--", "");
      while(d.options.length) d.options[d.options.length - 1] = null;
      d.options[0] = new Option("--", "");
      return;
    }

    if (mv == '') {
      while(m.options.length) m.options[m.options.length - 1] = null;
      m.options[0] = new Option("--", "");
      for (var month=1; month<=12; month++) {
        var tmp = (month <= 9) ? '0' + String(month) : String(month);
        m.options[m.options.length] = new Option(tmp, tmp);
      }
      while(d.options.length) d.options[d.options.length - 1] = null;
      d.options[0] = new Option("--", "");
      return;
    }

    var y_int = parseInt(yv, 10);
    var m_int = parseInt(mv, 10);

    var maxDay = 0;
    switch (parseInt(m_int, 10)) {
    case 4:
    case 6:
    case 9:
    case 11:
      maxDay = 30;
      break;
    case 2:
      if ((((y_int % 4) == 0) && (y_int % 100) != 0) || ((y_int % 400) == 0)) {
        maxDay = 29;
      } else {
        maxDay = 28;
      }
      break;
    default:
      maxDay = 31;
      break;
    }

    if (m.options.length != 13) {
      while(m.options.length) m.options[m.options.length - 1] = null;
      m.options[0] = new Option("--", "");
      for (var month=1; month<=12; month++) {
        var tmp = (month <= 9) ? '0' + String(month) : String(month);
        m.options[m.options.length] = new Option(tmp, tmp);
      }
      m.options[m_int].selected = true;
    }

    while(d.options.length) d.options[d.options.length - 1] = null;
    d.options[0] = new Option("--", "");
    for (var day=1; day<=maxDay; day++) {
      var tmp = (day <= 9) ? '0' + String(day) : String(day);
      d.options[d.options.length] = new Option(tmp, tmp);
    }

    if (dv != '') {
      d_int = parseInt(dv, 10);
      if (d_int > maxDay) d_int = maxDay;
      d.options[d_int].selected = true;
    }
  }
}


