<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroQuestionSearchResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - Yahoo!η:両ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * Yahoo!η:両
 *   http://developer.yahoo.co.jp/chiebukuro/questionSearch/V1/questionSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroQuestionSearchResponse.php,v 1.2 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceChiebukuroQuestionSearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡΥޥå꡼
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * ̤κǽΥݥ
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;
        case '/ResultSet/Result/Question': $i++; break;
        // ID
        case '/ResultSet/Result/Question/Id': $this->results[$i]['Id'] = $text; break;
        // ʸ
        case '/ResultSet/Result/Question/Content': $this->results[$i]['Content'] = $text; break;
        // ٥ȥ󥵡
        case '/ResultSet/Result/Question/BestAnswer': $this->results[$i]['BestAnswer'] = $text; break;
        // ܺ٥ڡURL
        case '/ResultSet/Result/Question/Url': $this->results[$i]['Url'] = $text; break;
        // ξ
        case '/ResultSet/Result/Question/Condition': $this->results[$i]['Condition'] = $text; break;
        // ɽƥ̾
        case '/ResultSet/Result/Question/CategoryPath': $this->results[$i]['CategoryPath'] = $text; break;
        // ɽƥID
        case '/ResultSet/Result/Question/CategoryIdPath': $this->results[$i]['CategoryIdPath'] = $text; break;
        // 
        case '/ResultSet/Result/Question/AnsCount': $this->results[$i]['AnsCount'] = $text; break;
        // 
        case '/ResultSet/Result/Question/PostedDate': $this->results[$i]['PostedDate'] = $text; break;
        // 
        case '/ResultSet/Result/Question/SolvedDate': $this->results[$i]['SolvedDate'] = $text; break;
        // Ƥμ
        case '/ResultSet/Result/Question/PostedDevice': $this->results[$i]['PostedDevice'] = $text; break;

        // =============================
        // 顼
        // =============================
        // 顼Ƚ
        case '/ResultSet/Status/StatusCode': if($text == '-1'){$this->error = true;} break;
        // 顼å
        case '/ResultSet/Status/Error/Message': $this->error_message .= '[code: ' . $attribute['code'] . '] ' . $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * ̥ǡ
     *
     * @access public
     * @return array ̥ǡ
     */
    function getResults()
    {
        return $this->results;
    }
}

?>
