<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchVideoRequest.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ư踡ѡ
 */
require_once 'SyL_WebServiceSearchVideoResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ư踡ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ư踡
 *   http://developer.yahoo.co.jp/search/video/V1/videoSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchVideoRequest.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceSearchVideoRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'search.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/VideoSearchService/V1/videoSearch';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceSearchVideoResponse';

    /**
     * ꡼򥻥åȤ
     *
     * @access public
     * @param string ꡼
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * 긡μ򥻥åȤ
     * (all, any, phrase)
     *
     * @access public
     * @param string 긡μ
     */
    function setType($type)
    {
        switch ($type) {
        case 'all':
        case 'any':
        case 'phrase':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ($type) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֵѷ̤ο򥻥åȤ
     *
     * @access public
     * @param int ֵѷ̤ο
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 0) && ($results <= 50))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ($results) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ֵѷ̤Ƭ֤򥻥åȤ
     *
     * @access public
     * @param int ֵѷ̤Ƭ
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start)) {
            $results = isset($this->parameters['results']) ? $this->parameters['results'] : 10;
            if (($start + $results - 1) <= 1000) {
                parent::set('start', $start);
            } else {
                trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `start' property ($start) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * եμ򥻥åȤ
     *
     * @access public
     * @param string եμ
     */
    function setFormat($format)
    {
        switch ($format) {
        case 'any':
        case 'avi':
        case 'flash':
        case 'mpeg':
        case 'msmedia':
        case 'quicktime':
        case 'realmedia':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `format' property ($format) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ȥƥĤθ̤ޤ뤫ɤ򥻥åȤ
     *
     * @access public
     * @param int ȥƥĤθ̤ޤ뤫ɤ
     */
    function setAdult_ok($adult_ok)
    {
        $adult_ok = ($adult_ok) ? '1' : '';
        parent::set('adult_ok', $adult_ok);
    }

    /**
     * ɥᥤ򥻥åȤ
     *
     * @access public
     * @param string or array ɥᥤ
     */
    function setSite($site)
    {
        parent::set('site', $site);
    }
}

?>
