<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlWriter.php,v 1.7 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/** 
 * XMLĥ꡼ǥ饹
 */
require_once 'SyL_XmlElement.php';
/** 
 * XMLĥ꡼ǥ롼ץ饹
 */
require_once 'SyL_XmlElements.php';

/** 
 * XML饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlWriter.php,v 1.7 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlWriter
{
    /**
     * XML󥳡
     * 
     * @access protected
     * @var string
     */
    var $xml_encode = 'UTF-8';
    /**
     * 󥳡
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = '';
    /**
     * XML
     * 
     * @access protected
     * @var array
     */
    var $xml = array();
    /**
     * ȤXML
     * 
     * @access protected
     * @var int
     */
    var $depth = 0;
    /**
     * XML
     * 
     * @access protected
     * @var string
     */
    var $declaration = array(
      'version'    => null,
      'standalone' => null
    );
    /**
     * DOCTYPE
     * 
     * @access protected
     * @var string
     */
    var $doctype = '';
    /**
     * XMLɲåե饰
     * 
     * @access protected
     * @var bool
     */
    var $is_eol = false;
    /**
     * ѡ顼å
     * 
     * @access protected
     * @var string
     */
    var $parse_error_message = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_XmlWriter()
    {
        $this->internal_encode = mb_internal_encoding();
    }

    /**
     * XMLʸɤ򥻥åȤ
     * 
     * @access public
     * @param string XMLʸ
     */
    function setXmlEncode($xml_encode)
    {
        $this->xml_encode = $xml_encode;
    }

    /**
     * ѥ᡼󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ѥ᡼󥳡
     */
    function setInternalEncode($internal_encode)
    {
        $this->internal_encode = $internal_encode;
    }

    /**
     * XMLʸɤ
     * 
     * @access public
     * @return string XMLʸ
     */
    function getXmlEncode()
    {
        return $this->xml_encode;
    }

    /**
     * XMLɲä
     *
     * @access public
     * @param string С
     * @param string standalone
     */
    function setDeclaration($version='1.0', $standalone='')
    {
        if ($version) {
            $this->declaration['version'] = $version;
        }
        if ($standalone) {
            $this->declaration['standalone'] = $standalone;
        }
    }

    /**
     * DOCTYPEɲä
     *
     * @access public
     * @param string DOCTYPE
     */
    function setDocType($doctype)
    {
        $this->doctype = "<!DOCTYPE {$doctype}>";
    }

    /**
     * ǤȤ˲Ԥɲä
     *
     * @access public
     * @param bool ԥե饰
     */
    function isEol($is_eol=true)
    {
        $this->is_eol = ($is_eol === true);
    }

    /**
     * ꤷϥɲä
     *
     * @access public
     * @param string ϥ
     * @param array ϥ°
     * @param string ϥΥƥ
     * @param bool ƥCDATAѥե饰
     */
    function addStartElement($tag, $attributes=array(), $text=null, $cdata=false)
    {
        if (count($this->xml) == 0) {
            $this->depth = 0;
        } else {
            $this->depth++;
        }
        $this->xml[$this->depth] = new SyL_XmlElements($tag, $attributes, $text, $cdata);
    }

    /**
     * 1ĤΥǡˤĤ
     *
     * @access public
     */
    function addEndElement()
    {
        if ($this->depth > 0) {
            $this->xml[$this->depth-1]->add($this->xml[$this->depth]);
            unset($this->xml[$this->depth]);
            $this->depth--;
        }
    }

    /**
     * 1ĤΥ˥ƥƤĤ
     *
     * @access public
     * @param string 
     * @param string °
     * @param string Υƥ
     * @param bool ƥCDATAѥե饰
     */
    function addElement($tag, $attributes=array(), $text=null, $cdata=false)
    {
        $this->xml[$this->depth]->add(new SyL_XmlElement($tag, $attributes, $text, $cdata));
    }

    /**
     * XML
     *
     * @access public
     * @param bool ѡåԤ
     * @return string XML
     */
    function create($parser_check=false)
    {
        $xml = '';
        $eol = '';
        if (count($this->xml[0]) > 0) {
            $eol = $this->xml[0]->eol;
            if ($this->declaration['version']) {
                $xml .= '<?xml ';
                foreach ($this->declaration as $name => $value) {
                    if ($value) {
                        $xml .= $name . '="' . $value . '" ';
                    }
                }
                if ($this->xml_encode) {
                    $xml .= 'encoding="' . $this->xml_encode . '" ';
                }
                $xml .= '?>';
                $xml .= $this->is_eol ? $eol : '';
            }
            if ($this->doctype) {
                $xml .= $this->doctype;
                $xml .= $this->is_eol ? $eol : '';
            }
            $xml .= $this->xml[0]->getTree($this->is_eol);
            $xml = ($this->internal_encode != $this->xml_encode) ? mb_convert_encoding($xml, $this->xml_encode, $this->internal_encode) : $xml;
            if ($parser_check) {
                $parser = xml_parser_create();
                if (!xml_parse($parser, $xml, true)) {
                    $this->parse_error_message = sprintf("[SyL error] XML Parser error: %s (Line %d)", xml_error_string(xml_get_error_code($parser)), xml_get_current_line_number($parser));
                }
                xml_parser_free($parser);
                if ($this->parse_error_message) {
                    return false;
                }
            }
        }

        return $xml;
    }

    /**
     * XML¸
     *
     * @access public
     * @param string ¸ե̾
     */
    function save($filename)
    {
        $xml = $this->create(false);
        $fp = fopen($filename, 'wb');
        fwrite($fp, $xml, strlen($xml));
        fclose($fp);
    }

    /**
     * ѡ顼å
     *
     * @access public
     * @return string ѡ顼å
     */
    function getParseErrorMessage()
    {
        return $this->parse_error_message;
    }
}

?>
