<?php
/**
 * ץꥱ̥󥯥饹
 *
 * @access    public
 * @package   {APP_NAME}
 * @author    {author}
 * @copyright {copyright}
 * @version   $Id: AppAction.php,v 1.1 2008/12/01 17:45:53 seasonstream Exp $
 */
class AppAction extends SyL_Action
{
    /**
     * ƥʥ󥹥ơ֥̾
     *
     * @var string
     */
    var $maintenance_table = 'a';

    /**
     * DB³ʸμ
     *
     * @access private
     * @param string ץե
     * @param string ץꥱե
     * @return string DB³ʸ
     */
    function getConnectionString($project_config_file, $app_config_file=null)
    {
        $config =& SyL_Config::factory('defines');
        if ($app_config_file) {
            $config->setConfigFiles(array($app_config_file, $project_config_file));
        } else {
            $config->setConfigFiles(array($project_config_file));
        }
        $config->parseXml(false);
        $values = $config->getConfig();

        if (!isset($values['SYL_DB_DSN']) || !$values['SYL_DB_DSN']) {
            trigger_error("[SyL error] `SYL_DB_DSN' constant not defined in config file({$project_config_file} or {$app_config_file})", E_USER_ERROR);
        }

        return $values['SYL_DB_DSN'];
    }

    /**
     * ơ֥륹޾
     *
     * @access private
     * @param string DB³ʸ
     * @param string ơ֥̾
     * @return array ơ֥륹޾
     */
    function getTableSchema($connection_string, $tablename)
    {
        // ơ֥륹޼
        $conn =& SyL_DB::getConnection($connection_string);
        $schema =& $conn->getSchema();
        $table_columns  = $schema->getColumns($tablename);
        $table_primary  = $schema->getPrimary($tablename);
        $table_uniques  = $schema->getUniques($tablename);
        $table_foreigns = $schema->getForeigns($tablename);
        $conn->closeConnection();

        return array($table_columns, $table_primary, $table_uniques, $table_foreigns);
    }

    function getTableClassSource($project_dir, $template_table_file, $table_name, $table_class, $table_columns, $table_primary=array(), $table_uniques=array(), $table_foreigns=array())
    {
        $columns  = array();
        foreach ($table_columns as $name => $column) {
            // ʸ
            $name = strtoupper($name);
            // ơ֥
            $columns[$name] = array(
              'type'     => $column['type'],
              'validate' => $this->getValidateDefinition($column)
            );
        }

        // ơ֥륯饹Ѵ
        $table_search  = array();
        $table_replace = array();
        // ץ̾
        $table_search[]  = '{PROJECT_NAME}';
        $table_replace[] = basename($project_dir);
        // 饹̾
        $table_search[]  = '{TABLE_CLASS_NAME}';
        $table_replace[] = SyL_Loader::convertClass($table_class);
        // ơ֥̾
        $table_search[]  = '{TABLE_NAME}';
        $table_replace[] = $table_name;
        // 祭
        $table_search[]  = '{TABLE_PRIMARY}';
        $table_replace[] = var_export($table_primary, true);
        // ե
        $table_search[]  = '{TABLE_UNIQUES}';
        $table_replace[] = var_export($table_uniques, true);
        // 
        $table_search[]  = '{TABLE_FOREIGNS}';
        $table_replace[] = var_export($table_foreigns, true);
        // 
        $table_search[]  = '{TABLE_COLUMNS}';
        $table_replace[] = var_export($columns, true);

        return str_replace($table_search, $table_replace, file_get_contents($template_table_file));
    }

    function getFormClassSource($project_dir, $template_form_file, $form_class, $table_name, $table_class, $table_columns, $table_primary=array())
    {
        $tables   = array();
        $elements = array();

        $tables[$this->maintenance_table] = $table_class;

        $i = 1;
        foreach ($table_columns as $name => $column) {
            // ʸ
            $name = strtoupper($name);
            // ե
            $elements[$name] = array(
              'alias'       => $this->maintenance_table,
              'type'        => 'text',
              'name'        => $name,
              'attributes'  => array('size' => '30'),
              'validate'    => array(),
              'sort_list'   => $i,
              'sort_detail' => $i
            );
            $i++;
        }

        // ȥ
        $sorts = array();
        foreach ($table_primary as $name) {
            $sorts[] = "{$this->maintenance_table}.{$name}.ASC";
        }

        // ե९饹Ѵ
        $form_search  = array();
        $form_replace = array();
        // ץ̾
        $form_search[]  = '{PROJECT_NAME}';
        $form_replace[] = basename($project_dir);
        // 饹̾
        $form_search[]  = '{FORM_CLASS_NAME}';
        $form_replace[] = SyL_Loader::convertClass($form_class);
        // ơ֥륯饹̾
        $form_search[]  = '{FORM_TABLES}';
        $form_replace[] = var_export($tables, true);
        // ᥤƥʥ󥹥ơ֥
        $form_search[]  = '{FORM_MAINTENANCE_TABLE}';
        $form_replace[] = $this->maintenance_table;
        // ǥեȥ
        $form_search[]  = '{FORM_SORTS}';
        $form_replace[] = var_export($sorts, true);
        // ե
        $form_search[]  = '{FORM_ELEMENTS}';
        $form_replace[] = var_export($elements, true);
        // ơ֥̾
        $form_search[]  = '{FORM_TITLE}';
        $form_replace[] = $table_name . '';

        return  str_replace($form_search, $form_replace, file_get_contents($template_form_file));
    }

    /**
     * ෿Хǡ
     *
     * @access private
     * @param array °
     * @param array Хǡ
     */
    function getValidateDefinition($column)
    {
        $validate = array();
        // ɬܥå
        if ($column['not_null']) {
            $validate['require'] = array('message' => '{name}ɬܤǤ');
        }
        switch ($column['type']) {
        // 
        case 'I':
            $validate['numeric'] = array(
              'message'    => '{name}ϿͤϤƤ',
              'parameters' => array(
                'dot' => false,
                'min' => $column['min'],
                'max' => $column['max'],
                'min_error_message' =>  '{name}{min}ʾϤƤ',
                'max_error_message' =>  '{name}{max}ʲϤƤ'
              )
            );
            break;

        // ư
        case 'F':
            $validate['numeric'] = array(
              'message'    => '{name}ϿͤϤƤ',
              'parameters' => array(
                'dot' => true
              )
            );
            break;

        // ͷ
        case 'N':
            $validate['numeric'] = array(
              'message'    => '{name}ϿͤϤƤ',
              'parameters' => array(
                'dot' => true,
                'min' => $column['min'],
                'max' => $column['max'],
                'min_error_message' =>  '{name}{min}ʾϤƤ',
                'max_error_message' =>  '{name}{max}ʲϤƤ'
              )
            );
            break;

        // շ
        case 'D':
        case 'DT':
            $validate['date'] = array(
              'message' => '{name}դϤƤ'
            );
            break;

        // ַ
        case 'T':
            $validate['regex'] = array(
              'message' => '{name}ޤ',
              'parameters' => array(
                'format' => '/^([0-1][0-9]|2[0-3]):?([0-5][0-9]):?([0-5][0-9])$/'
              )
            );
            break;

        // ʸ
        case 'S':
            $validate['length'] = array(
              'message'    => '{name}{max}ʸʥХȡ˰ϤƤ',
              'parameters' => array(
                'max' => $column['max']
              )
            );
            break;
        }
        return $validate;
    }

    /**
     * إפɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayHelp(&$cmd, $file)
    {
        $help = <<<EOF
Usage:
  php {$file} adm -d <dir> -w <name> [-a <dir>] [-c <file>] -t <table> [-s]
  php {$file} table -d <dir> [-w <name>] [-n <name>] [-p <name>] -t <table>
  php {$file} form -d <dir> [-w <name>] -f <name> [-n <name>] [-p <name>] -t <table>
  php {$file} [option]

Options:
  -d <dir>   project directory
  -w <name>  application name
  -a <dir>   action directory for Adm Application (default: null)
  -c <file>  controller file (default: null)
  -t <table> database table name
  -s         generate smarty template (default: PHP template)
  -f <name>  form class name. require SyL_Loader naming rule.
  -n <name>  table class name. require SyL_Loader naming rule. (default: table name)
  -p <name>  class prefix name. SyL_Loader naming rule. (default: null)
  -h         show this help, then exit
  -v         output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayVersion(&$cmd, $file)
    {
        $syl_version = SYL_VERSION;
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$syl_version} (PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (C) 2006-2008 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayDefault(&$cmd, $file)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
