<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateAction.php,v 1.5 2008/07/27 14:53:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եݡͥȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateAction.php,v 1.5 2008/07/27 14:53:09 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class CreateAction
{
    /**
     * ե
     *
     * @access public
     * @param object 󥽡륪֥
     * @param string ץȥǥ쥯ȥ
     * @param string ץꥱ̾
     * @param string ե
     */
    function trigger(&$cmd, $project_dir, $app_name, $action_file)
    {
        $action_dir = "{$project_dir}apps/{$app_name}/actions/";
        if (!is_dir($action_dir)) {
            $cmd->stdout("  -> creating directory {$action_dir}");
            if (!mkdir($action_dir, 0755)) {
                trigger_error("[SyL error] action directory can't create ({$action_dir})", E_USER_ERROR);
                exit;
            }
        }

        if (file_exists("{$project_dir}var/skel-templates/action.php")) {
            $action_template = "{$project_dir}var/skel-templates/action.php";
        } else {
            $action_template = SYL_PROJECT_DIR . '/var/skel-templates/action.php';
        }
        $contents = file_get_contents($action_template);

        if (!is_array($action_file)) {
            $action_file = array($action_file);
        }

        for ($i=0; $i<count($action_file); $i++) {
            if (preg_match('/^(\\\\|\/)/', $action_file[$i])) {
                $action_file[$i] = '/' . substr($action_file[$i], 1);
            }

            // 饹̾Ѵ
            $class_name = implode('_', array_map('ucfirst', preg_split('/(\\\\|\/)/', $action_file[$i])));
            $trans = array(
              '{{SYL_CLASS}}' => $class_name,
              '{{APP_NAME}}'  => $app_name
            );
            $contents_tmp = strtr($contents, $trans);

            $file = $action_dir . ucfirst($action_file[$i]) . '.php';
            $tmp = dirname($file) . '/';
            $create_dir = array();
            while (preg_match('/^' . preg_quote($action_dir, '/') . '/', $tmp)) {
                array_unshift($create_dir, $tmp);
                $tmp = dirname($tmp);
            }

            foreach ($create_dir as $dir) {
                if (!is_dir($dir)) {
                    $cmd->stdout("  -> creating directory {$dir}");
                    mkdir($dir, 0755);
                }
            }

            $cmd->stdout("  -> creating file {$file}");
            $fp = fopen($file, 'wb');
            fwrite($fp, $contents_tmp);
            fclose($fp);
        }
    }
}

?>
