<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationLst.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 上位レイヤーデータ管理クラス - 一覧処理
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationLst.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmOperationLst extends SyL_AdmOperation
{
    /**
     * オプション名変換時の元の値
     *
     * @access private
     * @var array
     */
    var $option_values = array();

    /**
     * 一覧表示データを取得する
     *
     * @access public
     * @param string ソート項目
     * @param int 検索ページ数
     * @return array 一覧表示データ
     */
    function getList($sort=null, $page=1, $limit='')
    {
        // ソート項目
        $sorts = ($sort) ? explode(',', $sort) : $this->form->getStructConfig('default_sort');
        // 1ページの表示件数
        if ($limit === '') {
            $limit = $this->form->getStructConfig('page_records');
        }

        // オプションをDBから取得している場合
        $data_sources = $this->form->getDataSources();

        $conn =& $this->dao->getConnection();

        // テーブルオブジェクト作成ループ
        $tables = array();
        $option_tmp_column = 'ADM_OPTION_COLUMN';
        $option_tmp_index  = 1;
        foreach (array_keys($this->tables) as $alias) {
            $table =& $this->tables[$alias];
            // オプションをDBから取得している場合、取得カラムを追加でセット
            foreach ($data_sources as $name => $data_source) {
                if ($alias == $data_source['alias']) {
                    if ($name != $data_source['value']) {
                        $tmp_option_column = $option_tmp_column . $option_tmp_index++;
                        $table->set($data_source['value'], $tmp_option_column);
                        $data_sources[$name]['value'] = $tmp_option_column;
                    }
                    $tmp_option_column = $option_tmp_column . $option_tmp_index++;
                    $table->set($data_source['name'], $tmp_option_column);
                    $data_sources[$name]['name'] = $tmp_option_column;
                }
            }

            // 検索条件
            $conditions = $this->dao->createCondition();
            foreach ($this->form->getValues($alias) as $column => $value) {
                if (is_array($value)) {
                    $in = array();
                    foreach ($value as $name => $value1) {
                        // 通常のselect, checkbox
                        if (is_int($name)) {
                            if (($value1 !== null) && ($value1 !== '')) {
                                $in[] = $value1;
                            }
                        // グルーピング要素
                        } else {
/*
                            if (is_array($value1)) {
                                foreach ($value1 as $value2) {
                                    if (($value2 !== null) && ($value2 !== '')) {
                                        $in[] = $value2;
                                    }
                                }
                            } else {
                                if (($value1 !== null) && ($value1 !== '')) {
                                    $conditions->addLike($column, '%' . $conn->escapeLike($value1) . '%');
                                }
                            }
*/
                        }
                    }
                    if (count($in) > 0) {
                        $conditions->addIn($column, $in);
                    }
                } else {
                    if (($value !== null) && ($value !== '')) {
                        $conditions->addLike($column, '%' . $conn->escapeLike($value) . '%');
                    }
                }
            } 
            $table->setConditions($conditions);

            // ソート条件
            $primarys = array();
            if ($alias == $this->form->getMaintenanceTable()) {
                $primarys = $this->getPrimary(true);
            }
            foreach ($sorts as $sort) {
                list($alias_tmp, $column_tmp) = explode('.', $sort, 3);
                if ($alias == $alias_tmp) {
                    $table->addSortLink($sort);
                    $key = array_search("{$alias_tmp}.{$column_tmp}", $primarys);
                    if ($key !== false) {
                        unset($primarys[$key]);
                    }
                }
            }
            foreach ($primarys as $primary) {
                $table->addSortLink("{$primary}.ASC");
            }

            $tables[$alias] =& $table;
        }

        // ページ情報セット
        $this->dao->setPage($page, $limit);
        // 表示データ取得
        $results = $this->dao->select($tables, $this->relation);

        // オプション表示名変換処理
        $options = array();
        $display_limits = array();
        foreach (array_keys($this->dao->getSelectHeaders()) as $name) {
            $options[$name] = $this->form->getOption($name);
            $element_config = $this->form->getConfig($name);
            $display_limits[$name] = (isset($element_config['display_limit_list']) && is_numeric($element_config['display_limit_list']))
                                   ? $element_config['display_limit_list']
                                   : null;
        }

        $cnt = count($results);
        for ($i=0; $i<$cnt; $i++) {
            // 固定オプション名変換
            foreach ($results[$i] as $name => $value) {
                if ($display_limits[$name] !== null) {
                    if (mb_strlen($results[$i][$name]) > $display_limits[$name]) {
                        $results[$i][$name] = mb_substr($results[$i][$name], 0, $display_limits[$name], SYL_ENCODE_INTERNAL) . '...';
                    }
                }
                if ($options[$name] !== null) {
                    // 値を待避
                    $this->option_values[$i][$name] = $results[$i][$name];
                    // オプション名に変更
                    $results[$i][$name] = isset($options[$name][$value]) ? $options[$name][$value] : '';
                }
            }
            // DB取得オプション名変換
            foreach ($data_sources as $name => $data_source) {
                // 値を待避
                $this->option_values[$i][$name] = $results[$i][$name];
                // オプション名に変更
                $results[$i][$name] = $results[$i][$data_source['name']];
            }
        }
        return $results;
    }

    /**
     * カレントの検索カラムと値を取得する
     *
     * @access public
     * @return array 一覧検索条件配列
     */
    function getSearchParameters()
    {
        $search_parameters = array();
        // テーブルオブジェクト作成ループ
        foreach (array_keys($this->tables) as $alias) {
            foreach ($this->form->getValues($alias) as $column => $value) {
                if (is_array($value)) {
                    foreach ($value as $column1 => $value1) {
                        // 通常のselect, checkbox
                        if (is_int($column1)) {
                            if (($value1 !== null) && ($value1 !== '')) {
                                $search_parameters[] = $column . '[]=' . urlencode($value1);
                            }
                        // グルーピング要素
                        } else {
/*
                            if (is_array($value1)) {
                                foreach ($value1 as $value2) {
                                    if (($value2 !== null) && ($value2 !== '')) {
                                        $search_parameters[] = $column1 . '[]=' . urlencode($value2);
                                    }
                                }
                            } else {
                                if (($value1 !== null) && ($value1 !== '')) {
                                    $search_parameters[] = $column1 . '=' . urlencode($value1);
                                }
                            }
*/
                        }
                    }
                } else {
                    if (($value != null) && ($value !== '')) {
                        $search_parameters[] = $column . '=' . urlencode($value);
                    }
                }
            }
        }
        return $search_parameters;
    }

    /**
     * ページオブジェクトを取得する
     *
     * @access public
     * @return object ページオブジェクト
     */
    function &getPager()
    {
        return $this->dao->getPager();
    }

    /**
     * 改ページリンク範囲配列を取得する
     *
     * @access public
     * @param object ページオブジェクト
     * @param int 改ページリンク表示幅
     * @return array 改ページリンク範囲配列
     */
    function getPageLinks(&$pager, $range=9)
    {
        list($start, $end) = $pager->getRange($range);
        $links = array();
        for ($i=$start; $i<=$end; $i++) {
            $links[] = $i;
        }
        return $links;
    }

    /**
     * ヘッダ表示項目を取得する
     *
     * @access public
     * @return array ヘッダ表示項目
     */
    function getSelectHeaders()
    {
        $headers     = array();
        $headers_tmp = $this->dao->getSelectHeaders();
        // 並び順と表示別名の変更
        foreach ($this->form->getListColumns() as $name) {
            $headers[$name] = $headers_tmp[$name];
            $element_config = $this->form->getConfig($name);
            $headers[$name]['name'] = $element_config['name'];
        }
        return $headers;
    }

    /**
     * カレントのソート項目を取得する
     *
     * @access public
     * @return array カレントのソート項目
     */
    function getSortColumns()
    {
        return implode(',', $this->dao->getSortColumns());
    }

    /**
     * デフォルト検索ボックス表示判定
     *
     * @access public
     * @return bool true: 表示、false: 非表示
     */
    function isDefaultSearchView()
    {
        if ($this->isSch()) {
            return (bool)$this->form->getStructConfig('default_search_view');
        } else {
            return false;
        }
    }

    /**
     * 一覧表示データに対応したプライマリーリンクを取得
     *
     * @access public
     * @param array 一覧表示データ配列
     * @return array プライマリーリンク配列
     */
    function getPrimaryLinkParameters(&$results)
    {
        $primary_link_parameters = array();
        $primaries = $this->getPrimary(false);
        foreach ($results as $i => $values) {
            $keys = array();
            foreach ($primaries as $name) {
                if (isset($this->option_values[$i][$name])) {
                    $keys[$name] = $this->option_values[$i][$name];
                } else {
                    $keys[$name] = $values[$name];
                }
            }
            $primary_link_parameters[$i] = $this->encodeKey($keys);
        }
        return $primary_link_parameters;
    }
}
