<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationNew.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 上位レイヤーデータ管理クラス - 新規登録処理
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationNew.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmOperationNew extends SyL_AdmOperation
{
    /**
     * クラスのプロパティからテーブルと関連を取得する
     *
     * @access public
     */
    function loadConfig()
    {
        parent::loadConfig();

        // データソースからマスタデータ取得
        $data_sources = $this->form->getDataSources();
        foreach ($data_sources as $name => $data_source) {
            // テーブルオブジェクト取得
            $table = null;
            if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
                $table = unserialize(serialize($this->tables[$data_source['alias']]));
            } else {
                $table = $this->tables[$data_source['alias']];
            }
            $table->initDataColumns();
            $table->set($data_source['name']);
            $table->set($data_source['value']);
            $table->addSort($data_source['name']);
            $table->addSort($data_source['value']);

            // 既存options配列
            $element_config = $this->form->getConfig($name);
            if (!isset($element_config['options'])) {
                $element_config['options'] = array();
            }
            foreach ($this->dao->select($table) as $values) {
                $column_name  = current($values);
                $column_value = next($values);
                $element_config['options'][$column_value] = $column_name;
            }
            $this->form->addConfig($name, $element_config);
        }
    }

    /**
     * バリデーションを実行
     *
     * @access public
     * @return bool バリデーション結果
     */
    function validate()
    {
        $result = parent::validate();
        if ($result) {
            // メインテーブル別名
            $name = $this->form->getMaintenanceTable();
            // 入力項目取得
            $input_columns = $this->form->getListColumns();

            foreach (array_keys($this->tables) as $alias) {
                if ($name == $alias) {
                    // 主キー存在チェック
                    $keys = array();
                    foreach ($this->tables[$alias]->getPrimary(false) as $column) {
                        if (in_array($column, $input_columns)) {
                            $keys[$column] = $this->form->getValue($column);
                            if (is_array($keys[$column]) && (count($keys[$column]) > 0)) {
                                $keys[$column] = current($keys[$column]);
                            }
                            if (($keys[$column] === null) || ($keys[$column] === '')) {
                                $keys = array();
                                break;
                            }
                        }
                    }
                    if (count($keys) > 0) {
                        if ($this->dao->hasPrimary($this->tables[$alias], $keys)) {
                            $result = false;
                            reset($keys);
                            $this->form->setErrorMessage(key($keys), implode(', ', array_map(array(&$this->form, 'getName'), array_keys($keys))) . '（主キー）は既に登録されています');
                        }
                    }

                    // 一意キー存在チェック
                    $keys = array();
                    foreach ($this->tables[$alias]->getUniques(false) as $columns) {
                        foreach ($columns as $column) {
                            if (in_array($column, $input_columns)) {
                                $keys[$column] = $this->form->getValue($column);
                                if (is_array($keys[$column]) && (count($keys[$column]) > 0)) {
                                    $keys[$column] = current($keys[$column]);
                                }
                                if (($keys[$column] === null) || ($keys[$column] === '')) {
                                    $keys = array();
                                    break;
                                }
                            }
                        }
                        if (count($keys) > 0) {
                            if ($this->dao->hasUnique($this->tables[$alias], $keys)) {
                                $result = false;
                                reset($keys);
                                $this->form->setErrorMessage(key($keys), implode(', ', array_map(array(&$this->form, 'getName'), array_keys($keys))) . '（一意キー）は既に登録されています');
                            }
                        }
                    }

                    // 外部キー存在チェック
                    $keys = array();
                    foreach ($this->tables[$alias]->getForeigns(false) as $columns) {
                        foreach (array_keys($columns) as $column) {
                            if (in_array($column, $input_columns)) {
                                $keys[$column] = $this->form->getValue($column);
                                if (is_array($keys[$column]) && (count($keys[$column]) > 0)) {
                                    $keys[$column] = current($keys[$column]);
                                }
                                if (($keys[$column] === null) || ($keys[$column] === '')) {
                                    $keys = array();
                                    break;
                                }
                            }
                        }
                        if (count($keys) > 0) {
                            if (!$this->dao->hasForeign($this->tables[$alias], $keys, $ftabble)) {
                                $result = false;
                                reset($keys);
                                $this->form->setErrorMessage(key($keys), implode(', ', array_map(array(&$this->form, 'getName'), array_keys($keys))) . "の関連（外部キー）が{$ftabble}テーブルに存在しません");
                            }
                        }
                    }

                    break;
                }
            }
        }
        return $result;
    }

    /**
     * 新規登録を行う
     *
     * @access public
     * @return bool true: OK、false: エラー 
     */
    function insert()
    {
        $table = null;
        // テーブルオブジェクト作成ループ
        foreach (array_keys($this->tables) as $alias) {
            if ($alias == $this->form->getMaintenanceTable()) {
                // 登録テーブルオブジェクト取得
                $table =& $this->tables[$alias];
                // データ項目初期化
                $table->initDataColumns();
                // デフォルト値取得
                $defaults = $this->form->getDefaults();
                // 登録データセット
                foreach ($this->form->getValues($alias) as $name => $value) {
                    if (isset($defaults[$name])) {
                        if (($value !== '') && ($value !== null)) {
                            // デフォルト値がある項目が入力されている場合は優先
                            unset($defaults[$name]);
                            $table->set($name, $value);
                        }
                    } else {
                        $table->set($name, $value);
                    }
                }
                // デフォルト値があればセット
                foreach ($defaults as $name => $value) {
                    if (is_array($value)) {
                        if (count($value) > 1) {
                            switch ($value[0]) {
                            case 'eval':
                                $table->set($name, eval("return {$value[1]};"));
                                break;
                            case 'function':
                                array_shift($value);
                                $table->set($name, $value);
                                break;
                            }
                        }
                    } else {
                        $table->set($name, $value);
                    }
                }
                break;
            }
        }
        if ($table) {
            return $this->dao->insert($table);
        } else {
            return false;
        }
    }
}
