<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorXmlrpc.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPC出力エラークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorXmlrpc.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ErrorXmlrpc extends SyL_Error
{
    /**
     * 404 Not Found の表示内容
     *
     * @access public
     */
    function forwardFileNotFoundDetail()
    {
        $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '(none)';
        SyL_Loggers::warn("404 Not Found. from {$referer}");
        SyL_Response::setStatusHeader('404');

        echo "404 Not Found";
    }

    /**
     * 環境別エラー処理
     * 
     * @access public
     * @param array エラーメッセージ配列
     * @param array エラートレース
     */
    function displayError($error_messages, $error_trace)
    {
        if (!ini_get('display_errors')) {
            return;
        }

        // XMLRPCリクエストパーサークラス
        include_once SYL_FRAMEWORK_DIR . '/lib/Xml/Rpc/SyL_XmlRpcBuilderServer.php';

        $builder =& new SyL_XmlRpcBuilderServer();
        // エラーNoをセット
        $builder->setErrorCode($this->controller->getErrorNo());
        // エラーメッセージをセット
        $builder->setErrorMessage(implode($this->eol, $error_messages));
        // エンコーディングをセット
        $builder->setEncoding(SYL_ENCODE_XMLRPC);

         // コンテンツタイプ
        $content_type = 'text/xml; charset=' . SYL_ENCODE_XMLRPC;
        SyL_Response::setHeader('Content-Type', $content_type);
        $response =& SyL_Response::singleton();
        $response->display($builder->build());
    }

    /**
     * ログ保存その他情報
     *
     * @access protected
     * @return string その他情報
     */
    function extraLog()
    {
        $error_message  = '';
        if (isset($_SERVER['REQUEST_METHOD']))  $error_message .= 'REQUEST_METHOD: ' . $_SERVER['REQUEST_METHOD']  . $this->eol;
        if (isset($_SERVER['REQUEST_URI']))     $error_message .= 'REQUEST_URI: '    . $_SERVER['REQUEST_URI']     . $this->eol;
        if (isset($_SERVER['HTTP_REFERER']))    $error_message .= 'REFERRER: '       . $_SERVER['HTTP_REFERER']    . $this->eol;
        if (isset($_SERVER['HTTP_USER_AGENT'])) $error_message .= 'USER_AGENT: '     . $_SERVER['HTTP_USER_AGENT'] . $this->eol;
        $error_message .= 'GET : '  . print_r($_GET, true);
        $error_message .= 'POST : ' . print_r($_POST, true);
        return $error_message;
    }

}
