<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterAuth.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * フィルタクラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Filter.php';
/**
 * 認証クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Auth.php';

/**
 * 認証フィルタクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterAuth.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FilterAuth extends SyL_Filter
{
    /**
     * 認証オブジェクト
     * 
     * @access private
     * @var object
     */
    var $auth = null;
    /**
     * 認証実行判定フラグ
     * 
     * @access private
     * @var bool
     */
    var $login = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_FilterAuth()
    {
        // 認証オブジェクト作成
        $this->auth =& SyL_Auth::singleton();
    }

    /**
     * 認証判定 or ログイン時は認証実行
     *
     * @access public
     * @param object データオブジェクト
     */
    function preAction(&$data)
    {
        // 認証エリア判定
        if ($this->auth->isAuthArea()) {
            // ログインアクション判定
            if ($this->auth->isLoginAction()) {
                // ログイン実行
                $this->login = $this->auth->doLogin();
                if (!$this->login) {
                    // セッションエラー画面へリダイレクト
                    SyL_Auth::redirectLoginError();
                }
            } else {
                // ログイン状態か判定
                if (!$this->auth->isLogin()) {
                    // 未ログインの場合
                    // セッションエラー画面へリダイレクト
                    SyL_Auth::redirectSessionError();
                }
            }
        }
    }

    /**
     * ログイン成功時は、TOP画面にリダイレクト
     *
     * @access public
     * @param object データオブジェクト
     */
    function postAction(&$data)
    {
        // 認証エリア判定
        if (is_bool($this->login) && $this->login) {
            // ログイン後TOPへリダイレクト
            SyL_Auth::redirectTop();
        }
    }
}
