<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LoggerFile.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ファイルクラス
 */
require_once SYL_FRAMEWORK_DIR . '/lib/SyL_File.php';

/**
 * ログファイルへのログ出力クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_LoggerFile.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_LoggerFile extends SyL_Logger
{
    /**
     * SyL_Fileオブジェクト
     * 
     * @access public
     */
    var $appender = null;

    /**
     * オープン
     *
     * @access public
     * @param string ログファイル名
     */
    function open($filename)
    {
        // ファイル名日付変換
        $search   = array('{YYYY}', '{MM}', '{DD}');
        $replace  = explode('-', date('Y-m-d'));
        $filename = str_replace($search, $replace, $filename);

        if ($this->appender == null) {
            $this->appender =& SyL_File::factory('a', $filename);
            $this->appender->setPermission(0666);
            $this->appender->open();
        }
    }

    /**
     * ログの出力
     *
     * @access public
     * @param string ログレベル名
     * @param string メッセージ
     */
    function log($level, $message)
    {
        if ($level != '') {
            $message = sprintf('%s [%s:%s] {%s} %s', date($this->datetime_format), SYL_ENV_TYPE, $level, $this->getLoggingClass(), rtrim($message));
        }
        if ($this->immediate || ($level == '')) {
            $this->appender->write($message . $this->eol);
        } else {
            $this->buffer[] = $message;
        }
    }

    /**
     * ファイルを閉じる
     *
     * @access public
     */
    function close()
    {
        if ($this->appender != null) {
            parent::close();
            $this->appender->close();
            $this->appender = null;
        }
    }
}
