<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_User.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ユーザークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_User.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_User
{
    /**
     * ログインID
     *
     * @access private
     * @var string
     */
    var $user_id = null;
    /**
     * ユーザーIDパラメータ名
     * 
     * @access protected
     * @var string
     */
    var $userid_param_name = 'login_username';
    /**
     * パスワードパラメータ名
     * 
     * @access protected
     * @var string
     */
    var $password_param_name = 'login_password';
    /**
     * ログイン認証時のパスワードハッシュ方法
     * array(CLIENT側のHASH化方法, SERVER側のHASH化方法)
     * 
     * @access protected
     * @var string
     */
    var $password_hash = array(null,null);

    /**
     * コンストラクタ
     * 
     * @access public
     */
    function SyL_User()
    {
    }

    /**
     * ユーザーIDをセット
     * 
     * @access public
     * @param string ユーザーID
     */
    function setUserId($user_id)
    {
        $this->user_id = $user_id;
    }

    /**
     * ユーザーIDを取得
     * 
     * @access public
     * @return string ユーザーID
     */
    function getUserId()
    {
        return $this->user_id;
    }

    /**
     * ログイン判定
     * 
     * @access public
     * @return bool true: ログイン済み、false: 未ログイン
     */
    function isLogin()
    {
        return ($this->user_id !== null);
    }

    /**
     * ユーザーIDパラメータ名をセット
     * 
     * @access public
     * @return string ユーザーIDパラメータ名
     */
    function getUserIdParamName()
    {
        return $this->userid_param_name;
    }

    /**
     * パスワードパラメータ名をセット
     * 
     * @access public
     * @return string パスワードパラメータ名
     */
    function getPasswordParamName()
    {
        return $this->password_param_name;
    }

    /**
     * ログイン認証時のパスワードハッシュ方法をセット
     * 
     * @access public
     * @return array ログイン認証時のパスワードハッシュ方法
     */
    function getPasswordHash()
    {
        return $this->password_hash;
    }

    /**
     * ログイン成功時に起動されるイベント
     * 
     * @access public
     * @param string ユーザーID
     */
    function triggerLoginSuccess($user_id)
    {
    }

    /**
     * ログインエラー時に起動されるイベント
     * 
     * @access public
     * @param string ユーザーID
     */
    function triggerLoginFailed($user_id)
    {
    }

    /**
     * ログアウト時に起動されるイベント
     * 
     * @access public
     * @param string ユーザーID
     */
    function triggerLogout($user_id)
    {
    }
}
