<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilExecutionTime.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 処理時間計測フィルタクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilExecutionTime.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 **/
class SyL_UtilExecutionTime
{
    /**
     * 計測開始時間格納
     * 
     * @param float
     */
    var $timer_start = 0;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_UtilExecutionTime()
    {
        $this->timer_start = $this->getNowMicroTime();
    }

    /**
     * ダイレクト取得メソッド
     *
     * @access public
     * @param object リクエストオブジェクト
     * @param object ビューデータオブジェクト
     */
    function getTime()
    {
        return $this->getExecutionTime();
    }

    /**
     * 計測表示処理
     *
     * @access public
     */
    function display()
    {
        $result = $this->getExecutionTime();
        $memory = -1;
        if (function_exists('memory_get_usage')) {
            $memory = memory_get_usage();
            if ($memory > 0) {
                $memory = round($memory/1024, 3);
            }
        }
        if ($memory >= 0) {
            echo "<br>[Execution: {$result}(s) Memory: {$memory}(KB)]<br>";
        } else {
            echo "<br>[Execution: {$result}(s)]<br>";
        }
    }

    /**
     * 現在時間を取得
     *
     * 例）list( $usec, $sec ) = explode( ' ', microtime() );
     *  $sec  = 1142084005 // UNIX timestamp
     *  $usec = 0.95226600
     *
     * @access public
     * @return float UNIXタイムスタンプをマイクロ秒まで
     */
    function getNowMicroTime()
    {
        list($usec, $sec) = explode(' ', microtime());
        return ((float)$sec + (float)$usec); 
    }

    /**
     * 実行時間を取得
     *
     * @access public
     * @return int 実行時間をmsまで
     */
    function getExecutionTime()
    {
        $execution_time = $this->getNowMicroTime() - $this->timer_start;
        return sprintf("%01.3F", round($execution_time, 3));
    }
}
