<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptビュークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJs.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ViewJs extends SyL_View
{
    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_ViewJs(&$context, &$data)
    {
        parent::SyL_View($context, $data);
        // コンテンツタイプをセット
        $this->setContentType('application/x-javascript; charset=' . SYL_ENCODE_INTERNAL);
    }

    /**
     * JavaScriptをインポートする
     * 
     * @access public
     */
    function importJs()
    {
    }

    /**
     * JavaScriptレンダリング実行
     * 
     * @access public
     */
    function render()
    {
        $this->importJs();
        // JavaScirpt出力
        $js  = $this->getJs();
        // アクションデータの出力
        $js .= $this->data->getJs();

        $this->setRender($js);
    }

    /**
     * JavaScript取得
     *
     * @access public
     * @return string JavaScript
     */
    function getJs()
    {
        $js = '';
        $imports = $this->data->getImport();
        if (count($imports) == 0) {
            return $js;
        }

        // パラメータ名変換
        foreach ($this->data->gets() as $name => $value) {
            $$name = $value;
        }

        // プロジェクト側ディレクトリ
        $paths1 = array();
        $paths1[] = SYL_APP_LIB_DIR;
        $paths1[] = SYL_PROJECT_LIB_DIR;

        // フレームワーク側ディレクトリ
        $paths2 = array();
        $paths2[] = SYL_FRAMEWORK_DIR . '/lib';
        $paths3 = array();
        $paths3[] = SYL_FRAMEWORK_DIR . '/core';

        ob_start();
        foreach ($imports as $mode) {
            $included = false;
            $file = SyL_Loader::convertPath($mode, 'SyL', 'js');
            foreach ($paths1 as $path) {
                if (is_file($path . $file)) {
                    include_once $path . $file;
                    $included = true;
                    break;
                }
            }
            if ($included) continue;

            $file = SyL_Loader::convertPath("JsClient.{$mode}", 'SyL', 'js');
            foreach ($paths2 as $path) {
                if (is_file($path . $file)) {
                    include_once $path . $file;
                    $included = true;
                    break;
                }
            }
            if ($included) continue;

            foreach ($paths3 as $path) {
                if (is_file($path . $file)) {
                    include_once $path . $file;
                    $included = true;
                    break;
                }
            }
        }
        $js = ob_get_clean();

        // インデント削除
        //$js = preg_replace('/(\r\n|\r|\n)[ \t]*/', "\n", $js);
        // コメント削除
        //$js = preg_replace('/\/\*(.*?)\*\//s', "", $js);
        //$js = preg_replace('/(\r\n|\r|\n)[ ]*\/\/([^(\r\n|\r|\n)]*)(\r\n|\r|\n)/', '$1', $js);

        return $js;
    }
}
