<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewSmarty.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Smartyクラス
 */
require_once SYL_SMARTY_DIR . 'Smarty.class.php';

/**
 * Smarty表示クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewSmarty.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ViewSmarty extends SyL_View
{
    /**
     * Smartyオブジェクト
     * 
     * @var object
     */
    var $smarty = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_ViewSmarty(&$context, &$data)
    {
        parent::SyL_View($context, $data);

        $this->smarty =& new Smarty();
        if (SYL_SMARTY_PARAMETER) {
            foreach(explode(';', SYL_SMARTY_PARAMETER) as $properties) {
                $tmp = explode('=', $properties, 2);
                if (count($tmp) == 2) {
                    list($name, $value) = $tmp;
                    if (isset($this->smarty->$name)) {
                        $this->smarty->$name = $value;
                    }
                }
            }
        }
    }

    /**
     * HTMLレンダリング実行
     * 
     * @access public
     */
    function render()
    {
        // コンテンツタイプをセット
        $this->setContentType('text/html; charset=' . SYL_ENCODE_INTERNAL);

        // アクションからのパラメータ取得
        $values =& $this->getActionValues();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key])) {
                $this->smarty->assign_by_ref($key, $values[$key]);
            } else {
                $this->smarty->assign($key, $values[$key]);
            }
        }

        // テンプレートディレクトリセット
        $this->smarty->template_dir = $this->getTemplateDir();
        // 表示内容をセット
        $this->setRender($this->smarty->fetch($this->getTemplateFile()));
    }
}
