<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilderColumn.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQLカラムデータクラス
 */
require_once 'SyL_DBSqlBuilderColumnData.php';

/**
 * SQLカラムクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilderColumn.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_DBSqlBuilderColumn
{
    /**
     * テーブルオブジェクト
     *
     * @access private
     * @var object
     */
    var $table = null;
    /**
     * カラム名
     *
     * @access private
     * @var string
     */
    var $name  = '';
    /**
     * カラム別名
     *
     * @access private
     * @var string
     */
    var $alias = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @param object テーブルオブジェクト
     * @param string カラム名
     * @param string カラム別名
     */
    function SyL_DBSqlBuilderColumn(&$table, $name, $alias='')
    {
        $this->table =& $table;
        $this->name  = $name;
        $this->alias = $alias;
    }

    /**
     * カラム名を取得する
     *
     * @access public
     * @return string テーブル名
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * カラム別名を取得する
     *
     * @access public
     * @return string カラム別名
     */
    function getNameAlias()
    {
        return $this->alias;
    }

    /**
     * SELECT句用カラム名を取得する
     *
     * @access public
     * @return string カラム名
     */
    function getNameSelect()
    {
        $table = $this->table->getNameAlias();
        if (!$table) {
            $table = $this->table->getName();
        }

        $alias = $this->getNameAlias();
        if ($alias) {
            return $table . '.' . $this->getName() . ' AS ' . $alias;
        } else {
            return $table . '.' . $this->getName();
        }
    }

    /**
     * WHERE句用カラム名を取得する
     *
     * @access public
     * @return string カラム名
     */
    function getNameWhere()
    {
        $table = $this->table->getNameAlias();
        if (!$table) {
            $table = $this->table->getName();
        }
        return $table . '.' . $this->getName();
    }

    /**
     * GROUP BY句用カラム名を取得する
     *
     * @access public
     * @return string カラム名
     */
    function getNameGroupBy()
    {
        $alias = $this->getNameAlias();
        if ($alias) {
            return $alias;
        } else {
            $table = $this->table->getName();
            return $table . '.' . $this->getName();
        }
    }

    /**
     * ORDER BY句用カラム名を取得する
     *
     * @access public
     * @return string カラム名
     */
    function getNameOrderBy()
    {
        return $this->getNameGroupBy();
    }

    /**
     * カラムデータオブジェクトを作成する
     *
     * @access public
     * @param string データ
     * @param string オペレータ
     * @return object カラムデータオブジェクト
     */
    function getColumnData($data, $operator='=')
    {
        return new SyL_DBSqlBuilderColumnData($this, $data, $operator);
    }
}
