<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostPlala_or_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * リモートホスト判定クラス (plala.or.jp)
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostPlala_or_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilRemoteHostPlala_or_jp extends SyL_UtilRemoteHost
{
    /**
     * ドメイン
     *
     * @access protected
     * @var string
     */
    var $domain = 'plala.or.jp';
    /**
     * プロバイダ名
     *
     * @access protected
     * @var string
     */
    var $provider = 'ぷらら';
    /**
     * プロバイダURL
     *
     * @access protected
     * @var string
     */
    var $url = 'http://www.plala.or.jp/';
    /**
     * 運営会社名
     *
     * @access protected
     * @var string
     */
    var $company = '株式会社ぷららネットワークス';

    /**
     * 都道府県判定用配列
     *
     * @access protected
     * @var array
     */
    var $prefectures = array(
      '.a001.' => '01',
      '.a002.' => '02',
      '.a003.' => '03',
      '.a004.' => '04',
      '.a005.' => '05',
      '.a006.' => '06',
      '.a007.' => '07',
      '.a008.' => '08',
      '.a009.' => '09',
      '.a010.' => '10',
      '.a011.' => '11',
      '.a012.' => '12',
      '.a013.' => '13',
      '.a014.' => '14',
      '.a015.' => '15',
      '.a016.' => '16',
      '.a017.' => '17',
      '.a018.' => '18',
      '.a019.' => '19',
      '.a020.' => '20',
      '.a021.' => '21',
      '.a022.' => '22',
      '.a023.' => '23',
      '.a024.' => '24',
      '.a025.' => '25',
      '.a026.' => '26',
      '.a027.' => '27',
      '.a028.' => '28',
      '.a029.' => '29',
      '.a030.' => '30',
      '.a031.' => '31',
      '.a032.' => '32',
      '.a033.' => '33',
      '.a034.' => '34',
      '.a035.' => '35',
      '.a036.' => '36',
      '.a037.' => '37',
      '.a038.' => '38',
      '.a039.' => '39',
      '.a040.' => '40',
      '.a041.' => '41',
      '.a042.' => '42',
      '.a043.' => '43',
      '.a044.' => '44',
      '.a045.' => '45',
      '.a046.' => '46',
      '.a047.' => '47'
    );

    /**
     * 回線種別判定用配列
     *
     * @access protected
     * @var array
     */
    var $connection_type = array(
      '.s01.' => 'isdn-ntt',
      '.s02.' => 'adsl-ntt',
      '.s03.' => 'opt-ntt', // Bフレ ファミリー
      '.s04.' => 'opt-ntt', // Bフレ マンション
      '.s05.' => 'opt-ntt', // Bフレ ニューファミリー
      '.s06.' => 'opt-ntt', // Bフレ ベーシック
      '.s07.' => 'opt-ntt', // Bフレ ビジネス
      '.s20.' => 'freed',
      '.s30.' => 'mflets',
      '.ras.' => 'dialup',
    );
}
