<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostSo_net_ne_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * リモートホスト判定クラス (so-net.ne.jp)
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilRemoteHostSo_net_ne_jp.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilRemoteHostSo_net_ne_jp extends SyL_UtilRemoteHost
{
    /**
     * ドメイン
     *
     * @access protected
     * @var string
     */
    var $domain = 'so-net.ne.jp';
    /**
     * プロバイダ名
     *
     * @access protected
     * @var string
     */
    var $provider = 'So-net';
    /**
     * プロバイダURL
     *
     * @access protected
     * @var string
     */
    var $url = 'http://www.so-net.ne.jp/';
    /**
     * 運営会社名
     *
     * @access protected
     * @var string
     */
    var $company = 'ソネットエンタテインメント株式会社';

    /**
     * 都道府県判定用配列
     *
     * @access protected
     * @var array
     */
    var $prefectures = array(
      '.hkid' => '01',
      '.sppr' => '01',
      '.aomr' => '02',
      '.iwat' => '03',
      '.miyg' => '04',
      '.sndi' => '04',
      '.akit' => '05',
      '.ymgt' => '06',
      '.fksm' => '07',
      '.ibrk' => '08',
      '.tocg' => '09',
      '.gunm' => '10',
      '.sitm' => '11',
      '.uraw' => '11',
      '.chib' => '12',
      '.toky' => '13',
      '.tkyo' => '13',
      '.ntky' => '13',
      '.kngw' => '14',
      '.ykhm' => '14',
      '.nigt' => '15',
      '.toym' => '16',
      '.iskw' => '17',
      '.fuki' => '18',
      '.ymns' => '19',
      '.ngno' => '20',
      '.gifu' => '21',
      '.szok' => '22',
      '.aici' => '23',
      '.ngya' => '23',
      '.mie-' => '24',
      '.siga' => '25',
      '.kyot' => '26',
      '.osak' => '27',
      '.hyog' => '28',
      '.kobe' => '28',
      '.nara' => '29',
      '.wkym' => '30',
      '.totr' => '31',
      '.simn' => '32',
      '.okym' => '33',
      '.hrsm' => '34',
      '.ymgc' => '35',
      '.tksm' => '36',
      '.kagw' => '37',
      '.ehim' => '38',
      '.koci' => '39',
      '.fkok' => '40',
      '.saga' => '41',
      '.ngsk' => '42',
      '.kmmt' => '43',
      '.oita' => '44',
      '.myzk' => '45',
      '.kgsm' => '46',
      '.oknw' => '47'
    );

    /**
     * 回線種別判定用配列
     *
     * @access protected
     * @var array
     */
    var $connection_type = array(
      'nt0' => 'flets',
      'ff0' => 'flets',
      'ea0' => 'adsl-eaccess',
      'ac0' => 'adsl-acca',
      'te0' => 'opt-tepco',
      'dc0' => 'freed',
      'ah0' => 'airedge'
    );
}
