<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilProperty.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 汎用プロパティクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilProperty.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilProperty
{
    /**
     * プロパティ
     * 
     * @access private
     * @var array
     */
    var $parameters = array();

    /**
     * プロパティをセット
     * 
     * @access public
     * @param string プロパティ名
     * @param string プロパティ値
     */
    function set($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * プロパティをセット（参照）
     * 
     * @access public
     * @param string プロパティ名
     * @param string プロパティ値
     */
    function setRef($name, &$value)
    {
        $this->parameters[$name] =& $value;
    }

    /**
     * 複数プロパティをセット
     * 
     * @access public
     * @param array プロパティ配列
     */
    function sets($values)
    {
        $this->parameters = array_merge($this->parameters, $values);
    }

    /**
     * 複数プロパティをセット（参照）
     * 
     * @access public
     * @param array プロパティ配列
     */
    function setsRef(&$values)
    {
        foreach (array_keys($values) as $name) {
            $this->parameters[$name] =& $values[$name];
        }
    }

    /**
     * プロパティを取得
     * 
     * @access public
     * @param string プロパティ名
     * @return string プロパティ値
     */
    function get($name)
    {
        if (isset($this->parameters[$name])) {
            return $this->parameters[$name];
        } else {
            return null;
        }
    }

    /**
     * プロパティを取得（参照）
     * 
     * @access public
     * @param string プロパティ名
     * @return string プロパティ値
     */
    function &getRef($name)
    {
        $value = null;
        if (isset($this->parameters[$name])) {
            $value =& $this->parameters[$name];
        }
        return $value;
    }

    /**
     * 全プロパティを取得
     * 
     * @access public
     * @return array 全プロパティ値
     */
    function gets()
    {
        return $this->parameters;
    }

    /**
     * 全プロパティを取得（参照）
     * 
     * @access public
     * @return array 全プロパティ値
     */
    function &getsRef()
    {
        return $this->parameters;
    }

    /**
     * プロパティを削除
     * 
     * @access public
     * @param string プロパティ名
     */
    function delete($name)
    {
        if (isset($this->parameters[$name])) {
            unset($this->parameters[$name]);
        }
    }

    /**
     * 全プロパティを削除
     * 
     * @access public
     */
    function deletes()
    {
        $this->parameters = array();
    }

    /**
     * プロパティの確認
     * 
     * @access public
     * @param string プロパティ名
     * @return bool true: プロパティあり、false: プロパティ無し
     */
    function is($name)
    {
        return isset($this->parameters[$name]);
    }

    /**
     * プロパティの数
     * 
     * @access public
     * @return int プロパティの数
     */
    function length()
    {
        return count($this->parameters);
    }

    /**
     * 全パラメータに指定関数を適用する
     * 
     * @access private
     * @param array パラメータ配列
     * @param string 関数名
     */
    function apply($func)
    {
        $func_parameters = func_get_args();
        $func = array_shift($func_parameters);
        $this->applyRecursive($func, $this->parameters, $func_parameters);
    }

    /**
     * 全パラメータに指定関数を適用する
     * 
     * @access private
     * @param string 関数名
     * @param array パラメータ
     * @param array 関数パラメータ
     */
    function applyRecursive($func, &$parameters, $args)
    {
        if (is_array($parameters)) {
            foreach($parameters as $key => $value) {
                $this->applyRecursive($func, $parameters[$key], $args);
            }
        } else {
            if (is_scalar($parameters)) {
                $parameters = call_user_func_array($func, array_merge((array)$parameters, $args));
            }
        }
    }
}
