<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilPropertyOverload.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 汎用プロパティクラス（オーバーロード）
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilPropertyOverload.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilPropertyOverload
{
    /**
     * プロパティ
     * 
     * @access protected
     * @var array
     */
    var $properties = array();

    /**
     * コンストラクタ
     * 
     * @access public
     */
    function SyL_UtilPropertyOverload()
    {
        if (version_compare(PHP_VERSION, '5.0.0', '<')) {
            overload(get_class($this));
        }
    }

    /**
     * プロパティをセット
     * 
     * @access public
     * @param string プロパティ名
     * @param string プロパティ値
     */
    function __set($name, $value) 
    {
        if (array_key_exists($name, $this->properties)) {
            $this->properties[$name] = $value;
            return true;
        } else {
            return false;
        }
    }

    /**
     * プロパティを取得
     * 
     * @access public
     * @param string プロパティ名
     * @param string プロパティ値
     */
    function __get($name, &$value) 
    {
        if (array_key_exists($name, $this->properties)) {
            $value = $this->properties[$name];
            return true;
        } else {
            return false;
        }
    }
}
