<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorLength.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * バイト数検証クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorLength.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ValidationValidatorLength extends SyL_ValidationValidator
{
    /**
     * パラメータ
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'min'               => 0,
      'min_error_message' => null,
      'max'               => null,
      'max_error_message' => null
    );

    /**
     * バイト数検証処理を実行する
     *
     * @access public
     * @param string 検証対象値
     * @return bool true: エラー無し, false: エラーあり
     */
    function validate($value)
    {
        $len = strlen($value);

        if ($this->parameters['min'] !== null) {
            if ($len < $this->parameters['min']) {
                if ($this->parameters['min_error_message'] !== null) {
                    $this->error_message = $this->parameters['min_error_message'];
                }
                return false;
            }
        }

        if ($this->parameters['max'] !== null) {
            if ($len > $this->parameters['max']) {
                if ($this->parameters['max_error_message'] !== null) {
                    $this->error_message = $this->parameters['max_error_message'];
                }
                return false;
            }
        }

        return true;
    }

    /**
     * バイト数検証処理のJavaScriptを取得する
     *
     * @access public
     * @return string JavaScript処理ロジック
     */
    function getJsCode()
    {
        $min = $this->parameters['min'];
        $max = $this->parameters['max'];
        $min_error_message = $this->parameters['min_error_message'];
        $max_error_message = $this->parameters['max_error_message'];

        $options = array();
        $options[] = "'min': '{$min}'";
        $options[] = "'max': '{$max}'";
        $options[] = "'min_error_message': '{$min_error_message}'";
        $options[] = "'max_error_message': '{$max_error_message}'";
        $options[] = "'min_valids': '{$this->min_valids}'";
        $options[] = "'max_valids': '{$this->max_valids}'";

        $js  = '';
        $js .= 'var message_tmp = validation.isLength(name, "' . $this->getErrorMessage() . '", {' . implode(',', $options) . '});' . "\n";
        $js .= 'if (message_tmp) {' . "\n";
        $js .= '  message = message_tmp;' . "\n";
        $js .= '}' . "\n";
        return $js;
    }
}
